<?php

namespace Sisi\Search\ServicesInterfaces;

use Elasticsearch\Client;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Interface InterfaceQuerylogService
 *
 * This interface defines the methods required for managing query logs in Elasticsearch.
 */
interface InterfaceQuerylogService
{
    /**
     * Creates the mapping for the query log index in Elasticsearch.
     *
     * @return array The mapping configuration for the query log index.
     */
    public function createMapping(): array;

    /**
     * Creates the settings for the query log index in Elasticsearch.
     *
     * @return array The settings configuration for the query log index.
     */
    public function createSettings(): array;
}