<?php

namespace Sisi\Search\ServicesInterfaces;

use Elasticsearch\Client;

/**
 * Interface InterfaceQuerylogSearchService
 *
 * This interface defines the contract for services that handle searching and inserting query logs.
 * It provides methods for searching the query log based on specific criteria and inserting new entries.
 */
interface InterfaceQuerylogSearchService
{

    /**
     * Searches the query log based on the provided criteria.
     *
     * @param array $config Configuration parameters for the search.
     * @param Client $client Elasticsearch client instance.
     * @param string $languageId Language ID for filtering the search.
     * @param array $terms Search terms to use for filtering.
     * @param string $saleschannelName Sales channel name for filtering.
     *
     * @return array An array containing the search results.
     */
    public function searchQuerlog(
        array $config,
        Client $client,
        string $languageId,
        array $terms,
        $saleschannelName
    ): array;

    /**
     * Inserts a new entry into the query log.
     *
     * @param array $fields Data to be inserted into the query log.
     * @param string $esIndex Elasticsearch index name where the data will be stored.
     * @param Client $client Elasticsearch client instance.
     *
     * @return array An array containing the result of the insertion operation.
     */
    public function insert(array $fields, string $esIndex, Client $client): array;
}