<?php

namespace Sisi\Search\Service;

use Doctrine\DBAL\Connection;
use phpDocumentor\Reflection\Types\Boolean;

/**
 * This class provides utility functions to handle product-related data,
 * specifically for checking and mapping stemming configurations.
 */
class ProductMoreService
{

    /**
     * @var array
     *
     * This array maps stemming configurations to their corresponding language codes or variations.
     * It's used to identify the correct language based on the provided stemming value.
     */
    private $values = [
        '_arabic_' => 'arabic',
        '_armenian_' => 'armenian',
        '_basque_' => 'basque',
        '_bengali_' => 'bengali',
        '_brazilian_' => 'brazilian',
        '_catalan_' => 'catalan',
        '_czech_' => 'czech',
        '_dutch_' => 'dutch',
        '_estonian_' => 'estonian',
        '_galician_' => 'galician',
        '_greek_' => 'greek',
        '_hindi_' => 'hindi',
        '_indonesian_' => 'indonesian',
        '_irish_' => 'irish',
        '_latvian_' => 'latvian',
        '_lithuanian_' => 'lithuanian',
        '_romanian_' => 'romanian',
        '_sorani_' => 'sorani',
        '_turkish_' => 'turkish',
        '_english_' => [
            'english',
            'light_english',
            'lovins',
            'minimal_english',
            'porter2',
            'possessive_english',
            'en'
        ],
        '_french_' => [
            'french',
            'light_french',
            'minimal_french'

        ],
        '_german_' => [
            'german',
            'light_german',
            'german2',
            'minimal_german',
            'de'
        ],
        '_norwegian_' => [
            'norwegia',
            'light_norwegian',
            'minimal_norwegian',
            'light_nynorsk',
            'minimal_nynorsk',
            'nynorsk'
        ],
        '_portuguese_' => [
            'portuguese',
            'light_portuguese',
            'minimal_portuguese',
            'portuguese_rslp'
        ],
        '_italian_' => [
            'light_italian',
            'italian'

        ],
        '_russian_' => [
            'russian',
            'light_russian'
        ],
        '_spanish_' => [
            'light_spanish',
            'spanish'
        ],
        '_swedish_' => [
            'swedish',
            'light_swedish'
        ]
    ];

    /**
     * Checks if a given stemming value exists in the configured list of stop words.
     *
     * @param string $stemming The stemming value to check.
     * @return int|string The key associated with the stemming value if found, otherwise an empty string.
     */
    public function checkstopWort(string $stemming)
    {
        // ---- Iterate through the configured stemming values.
        foreach ($this->values as $key => $val) {
            // ---- Check if the value is an array (multiple stemming options for a language).
            if (is_array($val)) {
                // ---- Check if the provided stemming value exists in the array.
                if (in_array($stemming, $val)) {
                    return $key;
                }
            } else {
                // ---- If the value is not an array, directly compare the stemming value.
                if ($stemming == $val) {
                    return $key;
                }
            }
        }
        // ---- Return an empty string if no match is found.
        return '';
    }
}