<?php

namespace Sisi\Search\Service;

use Doctrine\DBAL\Connection as DBconnection;
use Elasticsearch\Client;
use Exception;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Sisi\Search\Service\SearchHelpService;
use _HumbugBox01d8f9a04075\React\Socket\Connection;

class InsertTimestampService
{
    /**
     * @param array $parameters
     * @param Client $client
     * @param SalesChannelProductEntity $entity
     * @return void
     *
     * @SuppressWarnings(PHPMD)
     */
    public function deleteEntry(array $parameters, Client $client, SalesChannelProductEntity $entity)
    {
        if (array_key_exists('update', $parameters) && array_key_exists('time', $parameters)) {
            foreach ($parameters['esIndex'] as $index) {
                try {
                    $params = [
                        'index' => $index,
                        'id' => $entity->getid(),
                    ];
                    $client->delete($params);
                } catch (Exception $e) {
                    $this->deleteFallback($client, $index, $entity);
                }
            }
        }
    }

    /**
     *  @SuppressWarnings(PHPMD.EmptyCatchBlock )
     */
    public function deleteFallback(Client $client, string $index, SalesChannelProductEntity $entity)
    {
        $params['index'] = $index;
        $prodctnummer = $entity->getProductNumber();
        $params['body']['query']['match']['product_productNumber'] = $prodctnummer;
        $values = $client->search($params);
        if (array_key_exists('hits', $values['hits'])) {
            foreach ($values['hits']['hits'] as $value) {
                if (trim($value['_source']['product_productNumber']) === trim($prodctnummer)) {
                    try {
                        $params = [
                            'index' => $index,
                            'id' => $value['_id'],
                        ];
                        $client->delete($params);
                    } catch (Exception $e) {
                    }
                }
            }
        }
    }

    /**
     * @param int $time
     * @param array $parameters
     * @param DBconnection $connection
     * @param string $shopId
     * @param array $config
     * @return string|bool
     */
    public function getTheESIndex(int &$time, array $parameters, DBconnection $connection, string $shopId, array $config)
    {
        if (array_key_exists('update', $parameters)) {
            $heandler = new SearchHelpService();
            $config['strindexfinish'] = 'no';
            if (array_key_exists('language', $parameters)) {
                $lastindexMerker = $heandler->findLast($connection, $shopId, $parameters['language_id'], $config);
            } else {
                $lastindexMerker = $heandler->findLast($connection, $shopId, null, $config);
            }
            if ($lastindexMerker == false) {
                echo "No Index found\n";
                return false;
            }
            $time = $lastindexMerker['time'];
        }
        $esIndex = 'sisisearch';
        if (array_key_exists('language', $parameters)) {
            $esIndex .= '_' . strtolower($parameters['language']);
        }
        if (array_key_exists('prefix', $config)) {
            if (!empty($config['prefix'])) {
                $esIndex = $config['prefix'] . $esIndex;
            }
        }
        return $esIndex . '_' . $time;
    }
}
