<?php

declare(strict_types=1);

namespace Sisi\Search\Service;

use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\System\CustomField\CustomFieldTypes;
use Shopware\Core\Framework\Context;

/**
 * Service class for managing custom fields.
 * This class provides methods to create and manage custom fields within the Shopware system.
 */
class CustomFieldsService
{
    /**
     * @var EntityRepositoryInterface
     */
    private $customFieldSetRepository;

    /**
     * Constructor for the CustomFieldsService.
     *
     * @param EntityRepositoryInterface $customFieldSetRepository The repository for managing custom field sets.
     */
    public function __construct(EntityRepositoryInterface $customFieldSetRepository)
    {
        $this->customFieldSetRepository = $customFieldSetRepository;
    }

    /**
     * Creates custom fields.
     *
     * @param Context $context The context in which to create the custom fields.
     */
    public function setFieds(context $context): void
    {
        // ---- Define the data for the custom field set.
        $this->customFieldSetRepository->create(
            [
                [
                    'name' => 'sisi_test',
                    'customFields' => [
                        ['name' => 'sisi_test_size', 'type' => CustomFieldTypes::INT],

                    ]
                ]
            ],
            $context
        );
    }
}