<?php

namespace Sisi\Search\Service;

use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\Uuid\Uuid;

/**
 * Provides utility methods for creating and retrieving context and UUIDs.
 * @package Sisi\Search\Service
 * @SuppressWarnings(PHPMD.StaticAccess)
 */
class ContextService
{
    /**
     * Retrieves the default context.
     *
     * @return Context The default context.
     */
    public function getContext(): Context
    {
        return Context::createDefaultContext();
    }

    /**
     * Generates a random UUID as bytes.
     *
     * @return string The random UUID as bytes.
     */
    public function getUid(): string
    {
        return Uuid::randomBytes();
    }

    /**
     * Generates a random UUID as bytes.
     *
     * @return string The random UUID as bytes.
     */
    public function getRandom(): string
    {
        return Uuid::randomBytes();
    }

    /**
     * Generates a random UUID as a hexadecimal string.
     *
     * @return string The random UUID as a hexadecimal string.
     */
    public function getRandomHex(): string
    {
        return Uuid::randomHex();
    }

    /**
     * Converts a hexadecimal UUID string to its byte representation.
     *
     * @param string $valueId The hexadecimal UUID string to convert.
     *
     * @return string The byte representation of the UUID.
     */
    public function getFromHexToBytes(string $valueId): string
    {
        return Uuid::fromHexToBytes($valueId);
    }
}