<?php

namespace Sisi\Search\Service;

use Shopware\Core\Content\Media\Pathname\UrlGeneratorInterface;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;

/**
 * Class ContextService
 * @package Sisi\Search\Service
 */
class ChannelDataService
{
    public function getDatas(
        SalesChannelProductEntity $entity,
        array $config,
        string $lanugageId,
        UrlGeneratorInterface $urlGenerator
    ): SalesChannelProductEntity {
        if (array_key_exists('strchannel', $config)) {
            if ($config['strchannel'] === 'yes') {
                $newEnitity = new SalesChannelProductEntity();
                $tranlation = $entity->getTranslations();
                $name = "";
                foreach ($tranlation->getElements() as $tranlationItem) {
                    $lanugageIdEntity = (string)$tranlationItem->getLanguageId();
                    if (strtolower($lanugageIdEntity) == strtolower($lanugageId)) {
                        $name = $tranlationItem->getName();
                    }
                }
                if (empty($name)) {
                    $name = $entity->getName();
                }
                $newEnitity->setName($name);
                $newEnitity->setId($entity->getId());
                $newEnitity->setSortedProperties($entity->getSortedProperties());
                $newEnitity->setProductNumber($entity->getProductNumber());
                $this->insertNewDatas($entity, $newEnitity);
                $this->fixMediaUrl($newEnitity, $urlGenerator, $config);
                return $newEnitity;
            }
        }
        $this->fixMediaUrl($entity, $urlGenerator, $config);


        return $entity;
    }

    /**
     * @SuppressWarnings(PHPMD)
     *
     */
    public function fixMediaUrl(SalesChannelProductEntity &$entity, UrlGeneratorInterface $urlGenerator, array $config)
    {
        try {
            $cover = $entity->getCover();
            if ($cover !== null) {
                $media = $cover->getMedia();
                $url = $urlGenerator->getAbsoluteMediaUrl($media);
                $strthumbnial = false;
                if (array_key_exists('urlImage', $config)) {
                    if (!empty($config['urlImage'])) {
                        $url = $config['urlImage'] . DIRECTORY_SEPARATOR . $urlGenerator->getRelativeMediaUrl($media);
                        $strthumbnial = true;
                    }
                }
                $media->setUrl($url);
                $thumbnailsValues = $media->getThumbnails();
                if ($thumbnailsValues !== null) {
                    $thumbnails = $thumbnailsValues->getElements();
                    foreach ($thumbnails as $thumbnail) {
                        if ($strthumbnial) {
                            $thunburl = $config['urlImage'] . DIRECTORY_SEPARATOR . $urlGenerator->getRelativeThumbnailUrl($media, $thumbnail);
                        } else {
                            $thunburl = $urlGenerator->getAbsoluteThumbnailUrl($media, $thumbnail);
                        }
                        $thumbnail->setUrl($thunburl);
                    }
                }
            }
        } catch (\Exception $ex) {
        }
    }

    private function insertNewDatas(SalesChannelProductEntity $entity, SalesChannelProductEntity &$newEnitity): void
    {
        $nummer = $entity->getProductNumber();
        $cover = $entity->getCover();
        $media = $entity->getMedia();
        if ($nummer !== null && $nummer != false) {
            $entity->setProductNumber($nummer);
        }
        if ($cover !== null && $cover != false) {
            $newEnitity->setCover($cover);
        }
        if ($media !== null && $media != false) {
            $newEnitity->setMedia($media);
        }
    }
}
