import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';

export default class Sorting extends Plugin {
    
    static options = {
        sortingSelectSelector: '[data-sisi-sorting]',
    };

    init() {
        this._client = new HttpClient();
        this._registerEvents();
    }

    /**
     * Register all needed events
     * @private
     */
    _registerEvents() {
        const sortingSelects = document.querySelectorAll(this.options.sortingSelectSelector);
        
        sortingSelects.forEach(select => {
            select.addEventListener('change', this._onChangeSorting.bind(this));
        });
    }

    /**
     * Handle sorting change event
     * @param {Event} event
     * @private
     */
    _onChangeSorting(event) {
        const sortingValue = event.target.value;
        const currentUrl = new URL(window.location.href);
        
        // Update or add the sort parameter
        currentUrl.searchParams.set('sort', sortingValue);
        
        // Reset to page 1 when sorting changes
        if (currentUrl.searchParams.has('p')) {
            currentUrl.searchParams.set('p', '1');
        }
        
        // Navigate to the new URL
        window.location.href = currentUrl.toString();
    }
}