<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `excludesearch` column to the `s_plugin_sisi_search_es_fields` table.
 * 07/2024 created
 */
class Migration1656085043excludefield extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1656085043;
    }

    /**
     * This function updates the database schema by adding the `excludesearch` column
     * to the `s_plugin_sisi_search_es_fields` table if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Fetch the last record to check if the column exists
            $result = $this->findLast($connection);

            // ---- Check if the 'excludesearch' column exists in the result
            if (!array_key_exists("excludesearch", $result)) {
                // ---- Add the 'excludesearch' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields`  ADD `excludesearch` VARCHAR(55)  DEFAULT NULL COLLATE 'utf8mb4_unicode_ci'"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * This function is intentionally empty.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }

    /**
     * Retrieves the last record from the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @return mixed The last record as an associative array, or false if no record exists.
     */
    private function findLast(Connection $connection)
    {
        // ---- Build the query to select all columns from the table and limit the result to 1 row
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);

        // ---- Execute the query and fetch the result
        return $handler->execute()->fetch();
    }
}