<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration sets the `isfinish` flag to 1 in the `s_plugin_sisi_search_es_index` table.
 * This indicates that the indexing process has finished.
 */
class Migration1653128194setFinish extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1653128194;
    }

    /**
     * Executes the migration to set the `isfinish` flag to 1.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        // ---- SQL query to update the isfinish flag
        $sql = "UPDATE `s_plugin_sisi_search_es_index`
            SET
              `isfinish` = :isfinish";

        $connection->executeStatement(
            $sql,
            [
                'isfinish' => 1,
            ]
        );
    }

    /**
     * Executes destructive changes if needed. Currently, it only creates a query builder.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }
}