<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `isfinish` column to the `s_plugin_sisi_search_es_index` table.
 * This column is used to track whether the indexing process is finished.
 * 05/2022 created
 */
class Migration1653126356finishIndex extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1653126356;
    }

    /**
     * Executes the migration to add the `isfinish` column to the `s_plugin_sisi_search_es_index` table.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Add the `isfinish` column to the table.
            $connection->executeStatement(
                "ALTER TABLE `s_plugin_sisi_search_es_index`
                     ADD `isfinish` int default 0"
            );
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Executes destructive changes, currently a no-op.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }
}