<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * Creates the `sisi_search_es_log_channel` table to store search query logs.
 * 07/2024 created
 */
class Migration1652880057querylog extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1652880057;
    }

    /**
     * Creates the `sisi_search_es_log_channel` table.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        // SQL query to create the table
        $sql = "CREATE TABLE IF NOT EXISTS `sisi_search_es_log_channel` (
              `name` VARCHAR(255) DEFAULT '',
              `indexname` VARCHAR(255) DEFAULT '',
              `languageId` VARCHAR(255) DEFAULT '',
              `aktive` TINYINT DEFAULT 0,
              `created_at` DATETIME(3) NOT NULL,
              `updated_at` DATETIME(3) NULL,
              PRIMARY KEY (`indexname`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ";

        // ---- Execute the SQL statement to create the table
        $connection->executeStatement($sql);
    }

    /**
     * Executes destructive updates (not implemented in this migration).
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}