<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration updates the `s_plugin_sisi_search_es_fields` table to allow NULL values for the `shoplanguage` and `prefix` columns.
 * This is necessary to support cases where these fields are not required.
 * 07/2024 created
 */
class Migration1651236472AllowNull extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1651236472;
    }

    /**
     * Updates the database schema to allow NULL values for specific columns in the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Modify shoplanguage column to allow NULL values
            $connection->executeStatement(
                "ALTER TABLE `s_plugin_sisi_search_es_fields` CHANGE shoplanguage shoplanguage VARCHAR(255)  DEFAULT NULL"
            );

            // ---- Modify prefix column to allow NULL values
            $connection->executeStatement(
                "ALTER TABLE `s_plugin_sisi_search_es_fields` CHANGE prefix prefix VARCHAR(255)  DEFAULT NULL"
            );
        } catch (\Exception $ex) {
            // Silence is gold
        }
    }

    /**
     * Performs destructive updates on the database. Currently, this method only creates a query builder.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }
}