<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `onlymain` column to the `s_plugin_sisi_search_es_fields` table.
 */
class Migration1646643551onlymain extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1646643551;
    }

    /**
     * This function updates the database schema by adding the `onlymain` column to the `s_plugin_sisi_search_es_fields` table,
     * if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Check if the 'onlymain' column already exists
            $result = $this->findLast($connection);
            if (!array_key_exists("onlymamin", $result)) {
                // ---- Add the 'onlymain' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `onlymain` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }
    /**
     * Finds the last entry in the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @return array|false The last entry as an associative array, or false if no entry exists.
     */
    private function findLast(Connection $connection)
    {
        // ---- Build the query to select all columns from the table and limit the result to 1 row
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        // ---- Execute the query and fetch the result
        return $handler->execute()->fetch();
    }

    /**
     * This function is empty, as no destructive changes are needed.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}