<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration updates the `sisi_search_es_scheduledtask` table by adding a `days` column.
 */
class Migration1640185442updateIndexer extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1640185442;
    }

    /**
     * Executes the migration to add the `days` column to the `sisi_search_es_scheduledtask` table.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {

        try {
            // ---- Add the 'days' column to the 'sisi_search_es_scheduledtask' table
            $connection->executeStatement(
                "ALTER TABLE sisi_search_es_scheduledtask ADD days VARCHAR(255) DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER kind"
            );
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Executes destructive changes, which are not implemented in this migration.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}