<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `shoplanguage` column to the `s_plugin_sisi_search_es_fields` table.
 * This column is used to store the language of the shop.
 */
class Migration1631093748shoplanguage extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1631093748;
    }

    /**
     * This function updates the database schema by adding the `shoplanguage` column to the `s_plugin_sisi_search_es_fields` table,
     * if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Check if the 'shoplanguage' column already exists
            $result = $this->findLast($connection);
            if (!array_key_exists("shoplanguage", $result)) {
                // ---- Add the 'shoplanguage' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `shoplanguage` VARCHAR(255)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `filter3`"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }


    /**
     * This function is intentionally empty.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }

    /**
     * Retrieves the first row from the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @return array|false An associative array representing the first row, or false if the table is empty.
     */
    private function findLast(Connection $connection)
    {
        // ---- Build the query to select all columns from the table and limit the result to 1 row
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        // ---- Execute the query and fetch the result
        return $handler->execute()->fetch();
    }
}