<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `phpfilter` column to the `s_plugin_sisi_search_es_fields` table.
 * The `phpfilter` column is used to store a PHP filter that can be applied to the field during indexing.
 * 07/2024 created
 */
class Migration1625654055phpfilter extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1625654055;
    }

    /**
     * Executes the migration to add the `phpfilter` column to the `s_plugin_sisi_search_es_fields` table,
     * if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Fetch the last record to check if the column exists
            $result = $this->findLast($connection);

            // ---- Check if the 'phpfilter' column exists in the result
            if (!array_key_exists("phpfilter", $result)) {
                // ---- Add the 'phpfilter' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `phpfilter` VARCHAR(500)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `filter3`"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Executes destructive changes (not implemented).
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }

    /**
     * Retrieves the last record from the `s_plugin_sisi_search_es_fields` table to check for column existence.
     *
     * @param Connection $connection The database connection.
     * @return mixed The last record as an associative array.
     */
    private function findLast(Connection $connection)
    {
        // ---- Build the query to select all columns from the table and limit the result to 1 row
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);

        // ---- Execute the query and fetch the result
        return $handler->execute()->fetch();
    }
}