<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the 'exclude' column to the 's_plugin_sisi_search_es_fields' table.
 * 03/2021 created
 */
class Migration1617005993exclude extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1617005993;
    }

    /**
     * Executes the migration to add the 'exclude' column if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Check if the 'exclude' column already exists
            $result = $this->findLast($connection);
            if (!array_key_exists("exclude", $result)) {
                // ---- Add the 'exclude' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `exclude` VARCHAR(55)
            DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `filter3`"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * This method is empty and does nothing.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }

    /**
     * Retrieves the last record from the 's_plugin_sisi_search_es_fields' table.
     *
     * @param Connection $connection The database connection.
     * @return mixed The last record as an associative array, or false if no record exists.
     */
    private function findLast(Connection $connection)
    {
        // ---- Build the query to select all columns from the table and limit the result to 1 row
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        // ---- Execute the query and fetch the result
        return $handler->execute()->fetch();
    }
}