<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds a 'whitespace' column to the 's_plugin_sisi_search_es_fields' table.
 */
class Migration1612341396whitespace extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1612341396;
    }

    /**
     * This function updates the database schema by adding the 'whitespace' column
     * to the 's_plugin_sisi_search_es_fields' table if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Find the last entry in the table to check if the 'whitespace' column exists.
            $result = $this->findLast($connection);

            // ---- Check if the 'whitespace' column exists in the result.
            if (!array_key_exists("whitespace", $result)) {
                // ---- Add the 'whitespace' column to the table.
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `whitespace` VARCHAR(55)
                                            DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `filter3`"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Finds the last entry in the 's_plugin_sisi_search_es_fields' table.
     *
     * @param Connection $connection The database connection.
     * @return mixed The last entry in the table as an associative array.
     */
    private function findLast(Connection $connection)
    {
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        return $handler->execute()->fetch();
    }

    /**
     * This function is intentionally empty.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}