<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Sisi\Search\Service\ContextService;

/**
 * This migration adds a new field configuration to the `s_plugin_sisi_search_es_fields` table
 * for the 'properties' table, configuring it for Elasticsearch indexing.
 */
class Migration1603055209properties extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1603055209;
    }

    /**
     * This function is executed when the migration is applied.
     * It inserts a new field configuration into the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        $values['nameField'] = 'name';
        $values['tablename'] = 'properties';
        $values['fieldtype'] = 'text';
        $values['edge'] = '2';
        $values['minedge'] = '2';
        $values['tokenizer'] = 'Edge_n-gram_tokenizer';
        $values['shop'] = '';
        $values['format'] = '';
        $values['filter1'] = 'lowercase';
        $values['filter2'] = '';
        $values['stemming'] = '';
        $values['stop'] = '';
        $values['stemmingstop'] = '';
        $this->insertField($connection, $values);
    }

    /**
     * This function is executed when the migration is reverted.
     * It's currently empty, meaning no destructive changes are reverted.
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
        $connection->createQueryBuilder();
    }

    /**
     * Inserts a new field configuration into the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @param array $values An array containing the field configuration values.
     */
    private function insertField(Connection $connection, array $values): void
    {
        $contextService = new ContextService();

        // ---- Construct the SQL query for inserting the field configuration.
        $sql = "
          INSERT INTO `s_plugin_sisi_search_es_fields` (`id`, `name`,  `tablename`,`fieldtype`,`edge`,`minedge`,
          `tokenizer`,`shop`,`format`,
          `filter1`, `filter2`, `stemming`, `stop`, `stemmingstop`,`created_at`, `updated_at`)
          VALUES
          (:id, :nameField,:tablename,:fieldtype,:edge,:minedge,:tokenizer,
           :shop,:format,:filter1,:filter2,:stemming,:stop, :stemmingstop, now(), now())";

        // ---- Execute the SQL query with the provided values.
        $connection->executeStatement(
            $sql,
            [
                'id' => $contextService->getRandom(),
                'nameField' => $values['nameField'],
                'tablename' => $values['tablename'],
                'fieldtype' => $values['fieldtype'],
                'tokenizer' => $values['tokenizer'],
                'edge' => $values['edge'],
                'minedge' => $values['minedge'],
                'shop' => $values['shop'],
                'format' => $values['format'],
                'filter1' => $values['filter1'],
                'filter2' => $values['filter2'],
                'stemming' => $values['stemming'],
                'stop' => $values['stop'],
                'stemmingstop' => $values['stemmingstop']
            ]
        );
    }
}