<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds several new columns to the `s_plugin_sisi_search_es_fields` table.
 * These columns are related to fuzzy search configurations, such as `fuzzy`, `maxexpansions`, `slop`, `operator`,
 * `autosynonyms`, `minimumshouldmatch`, `prefixlength`, and `lenient`.
 * 07/2024 created
 */
class Migration1601799488fuzzy extends MigrationStep
{
    /**
     * Returns the creation timestamp of this migration.
     *
     * @return int The creation timestamp.
     */
    public function getCreationTimestamp(): int
    {
        return 1601799488;
    }

    /**
     * Executes the update logic to add new columns to the `s_plugin_sisi_search_es_fields` table if they don't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        $result = $this->findLast($connection);
        if ($result != false) {
            $this->setAllQuerys1($connection, $result);
            $this->setAllQuerys2($connection, $result);
        }
    }

    /**
     * Adds columns related to fuzzy search configurations to the `s_plugin_sisi_search_es_fields` table.
     * This method adds `fuzzy`, `maxexpansions`, `slop`, and `operator` columns.
     *
     * @param Connection $connection The database connection.
     * @param array $result The result of the last record in the table.
     */
    private function setAllQuerys1(Connection $connection, array $result): void
    {
        try {
            // ---- Add 'fuzzy' column if it doesn't exist
            if (!array_key_exists("fuzzy", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `fuzzy` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'maxexpansions' column if it doesn't exist
            if (!array_key_exists("maxexpansions", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `maxexpansions` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'slop' column if it doesn't exist
            if (!array_key_exists("slop", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `slop` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'operator' column if it doesn't exist
            if (!array_key_exists("operator", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `operator` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Adds more columns related to fuzzy search configurations to the `s_plugin_sisi_search_es_fields` table.
     * This method adds `autosynonyms`, `minimumshouldmatch`, `prefixlength`, and `lenient` columns.
     *
     * @param Connection $connection The database connection.
     * @param array $result The result of the last record in the table.
     */
    private function setAllQuerys2(Connection $connection, array $result): void
    {
        try {
            // ---- Add 'autosynonyms' column if it doesn't exist
            if (!array_key_exists("autosynonyms", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `autosynonyms` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'minimumshouldmatch' column if it doesn't exist
            if (!array_key_exists("minimumshouldmatch", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `minimumshouldmatch` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'prefixlength' column if it doesn't exist
            if (!array_key_exists("prefixlength", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `prefixlength` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
            // ---- Add 'lenient' column if it doesn't exist
            if (!array_key_exists("lenient", $result)) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields` ADD `lenient` VARCHAR(55)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Finds the last record in the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @return array|bool The last record as an associative array, or false if no record is found.
     */
    private function findLast(Connection $connection)
    {
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        return $handler->execute()->fetch();
    }

    /**
     * Executes destructive updates (not implemented).
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}