<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the 'language' column to the 's_plugin_sisi_search_es_index' table.
 * This column is used to store the language associated with each search index entry.
 * 07/2024 created
 */
class Migration1599558860lanugage extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1599558860;
    }

    /**
     * Executes the migration to add the 'language' column if it doesn't already exist.
     * This method checks for the existence of the 'language' column in the 's_plugin_sisi_search_es_index' table.
     * If the column does not exist, it adds the column with a VARCHAR(255) data type, a default value of an empty string,
     * and a collation of 'utf8mb4_unicode_ci'.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Check if the 'language' column already exists
            $result = $this->findLast($connection);
            // ---- If the column doesn't exist, add it
            if ($result == false) {
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_index` ADD `language` VARCHAR(255)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Checks if the 'language' column exists in the 's_plugin_sisi_search_es_index' table.
     * This method queries the database to determine if the 'language' column already exists in the specified table.
     *
     * @param Connection $connection The database connection.
     * @return mixed Returns the column information if it exists, or false otherwise.
     */
    private function findLast(Connection $connection)
    {
        $sql = "SHOW COLUMNS FROM `s_plugin_sisi_search_es_index` LIKE 'language'";
        return $connection->query($sql)->fetchColumn();
    }

    /**
     * Executes destructive changes (not implemented in this migration).
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}