<?php

declare(strict_types=1);

namespace Sisi\Search\Migration;

use Doctrine\DBAL\Connection;
use Exception;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * This migration adds the `filter3` column to the `s_plugin_sisi_search_es_fields` table.
 * 07/2024 created
 */
class Migration1596557182filter3 extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1596557182;
    }

    /**
     * Executes the migration to add the `filter3` column if it doesn't already exist.
     *
     * @param Connection $connection The database connection.
     */
    public function update(Connection $connection): void
    {
        try {
            // ---- Check if the 'filter3' column already exists
            $result = $this->findLast($connection);
            if (!array_key_exists("filter3", $result)) {
                // ---- Add the 'filter3' column to the table
                $connection->executeStatement(
                    "ALTER TABLE `s_plugin_sisi_search_es_fields`
                        ADD `filter3` VARCHAR(500)  DEFAULT '' COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `filter2`"
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    /**
     * Retrieves the last row from the `s_plugin_sisi_search_es_fields` table.
     *
     * @param Connection $connection The database connection.
     * @return mixed An array representing the last row, or false if the table is empty.
     */
    private function findLast(Connection $connection)
    {
        $handler = $connection->createQueryBuilder()
            ->select(['*'])
            ->from('s_plugin_sisi_search_es_fields')
            ->setMaxResults(1);
        return $handler->execute()->fetch();
    }

    /**
     * Executes destructive changes (currently empty).
     *
     * @param Connection $connection The database connection.
     */
    public function updateDestructive(Connection $connection): void
    {
        $connection->createQueryBuilder();
    }
}