<?php

declare(strict_types=1);

namespace Sisi\Search\Events;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Shopware\Storefront\Page\Suggest\SuggestPage;
use Symfony\Component\HttpFoundation\Request;

/**
 * Event triggered after the suggest page has been loaded.
 * This event allows modification of the suggest page data.
 */
class SisiSuggestPageLoadedEvent extends PageLoadedEvent
{
    /**
     * @var SuggestPage
     */
    protected $page;

    /**
     * Constructor for the SisiSuggestPageLoadedEvent.
     *
     * @param SuggestPage $page The loaded suggest page.
     * @param SalesChannelContext $salesChannelContext The sales channel context.
     * @param Request $request The current request.
     */
    public function __construct(SuggestPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): SuggestPage
    {
        return $this->page;
    }
}