<?php

namespace Sisi\Search\ESindexing;

use Shopware\Core\System\SystemConfig\SystemConfigService;
use Shopware\Elasticsearch\Framework\ElasticsearchHelper;
use Sisi\Search\ESIndexInterfaces\InterfaceProduktDataMapping;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Sisi\Search\Service\ProductService;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Context;
use Doctrine\DBAL\Connection;
use Elasticsearch\ClientBuilder;
use Shopware\Core\Framework\Uuid\Uuid;
use Sisi\Search\Service\SearchService;
use Sisi\Search\Commands\ProductIndexerCommand;

/**
 * This class is responsible for defining the Elasticsearch mapping for product data.
 * It implements the InterfaceProduktDataMapping interface.
 */
class ProduktDataMapping implements InterfaceProduktDataMapping
{
    /**
     * Returns the Elasticsearch mapping for product data.
     *
     * @param array $mapping The base mapping array.
     * @return array The modified mapping array.
     */
    public function getMapping(array $mapping): array
    {
        return $mapping;
    }
}