<?php

namespace Sisi\Search\ESindexing;

use Doctrine\DBAL\Exception;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Sisi\Search\ESIndexInterfaces\InterfaceInsertProduktDataIndex;
use Sisi\Search\Service\InsertMainMethode;
use Symfony\Bridge\Monolog\Logger;
use Elasticsearch\Client;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Symfony\Component\Console\Output\OutputInterface;
use Sisi\Search\Service\InsertService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * This class is responsible for indexing product data into Elasticsearch.
 * It uses the InsertService and InsertMainMethode classes to handle the insertion process,
 * including dynamic products.
 */
class InserProduktDataIndex implements InterfaceInsertProduktDataIndex
{
    /**
     * @var InsertQuery
     */
    protected $insertQuery;


    /**
     * InserProduktDataIndex constructor.
     * @param InsertQuery $insertQuery
     */
    public function __construct($insertQuery)
    {
        $this->insertQuery = $insertQuery;
    }

    /**
     * Indexes product data into Elasticsearch.
     *
     * This method takes a collection of product entities and their mapping values,
     * and inserts them into the Elasticsearch index. It also handles dynamic products
     * if they are present.
     *
     * @param EntitySearchResult $entities The product entities to index.
     * @param EntitySearchResult $mappingValues The mapping values for the product entities.
     * @param Client $client The Elasticsearch client.
     * @param string $lanugageId The language ID for the product data.
     * @param Logger $loggingService The logging service.
     * @param OutputInterface|null $output The output interface for displaying progress.
     * @param array $parameters An array of parameters, including configuration and sales channel context.
     * @param ContainerInterface $container The dependency injection container.
     *
     * @throws Exception
     */
    public function setIndex(
        &$entities,
        $mappingValues,
        $client,
        $lanugageId,
        $loggingService,
        $output,
        $parameters,
        $container
    ): void {
        $insertService = new InsertService();
        $heandlerDynamisch = new InsertMainMethode();
        $merkerIdsFordynamicProducts = [];

        // ---- Index the main product entities
        $insertService->setIndex(
            $entities,
            $mappingValues,
            $client,
            $lanugageId,
            $loggingService,
            $output,
            $this->insertQuery,
            $parameters,
            $container,
            $merkerIdsFordynamicProducts
        );

        // ---- Handle dynamic products if any are found
        if (count($merkerIdsFordynamicProducts) > 0) {
            $saleschannelContext = $parameters['saleschannelContext'];
            $createCriteria = $parameters['createCriteria'];
            $criteria = new Criteria();
            $createCriteria->getCriteria($criteria);
            $dynamicproducts = $heandlerDynamisch->getDynamicproduct($criteria, $merkerIdsFordynamicProducts, $container, $saleschannelContext);
            $parameters['config']['addVariants'] = 'no';

            // ---- Index the dynamic products
            $insertService->setIndex(
                $dynamicproducts,
                $mappingValues,
                $client,
                $lanugageId,
                $loggingService,
                $output,
                $this->insertQuery,
                $parameters,
                $container,
                $merkerIdsFordynamicProducts
            );
        }
    }
}