<?php

namespace Sisi\Search\ESindexing;

use Elasticsearch\Client;
use Sisi\Search\ESIndexInterfaces\InterfaceCreateIndex;

/**
 * This class is responsible for creating an index in Elasticsearch.
 * It implements the InterfaceCreateIndex interface.
 */
class CreateIndex implements InterfaceCreateIndex
{
    /**
     * Creates an index in Elasticsearch using the provided client and parameters.
     *
     * @param Client $client The Elasticsearch client.
     * @param array $params The parameters for creating the index.
     * @return array The response from the Elasticsearch client after creating the index.
     */
    public function setInsert(Client $client, array $params): array
    {
        return $client->indices()->create($params);
    }
}