<?php

namespace Sisi\Search\ESindexing;

use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Sisi\Search\ESIndexInterfaces\InterfaceCreateCriteria;

/**
 * This class is responsible for creating and configuring a Criteria object
 * for fetching product data during Elasticsearch indexing. It adds necessary
 * associations to the Criteria to ensure that related data is also retrieved.
 */
class CreateCriteria implements InterfaceCreateCriteria
{
    /**
     * Configures the provided Criteria object by adding associations required for product indexing.
     * This method adds associations to the criteria for related entities like cover, manufacturer, categories, etc.
     * These associations are necessary to fetch all required data for indexing products in Elasticsearch.
     *
     * @param Criteria $criteria The Criteria object to configure.
     */
    public function getCriteria(Criteria &$criteria): void
    {
        // ---- Add associations to the criteria for related entities.
        $criteria->addAssociation('cover');
        $criteria->addAssociation('cover.media.thumbnails');
        $criteria->addAssociation('manufacturer');
        $criteria->addAssociation('manufacturer.translations');
        $criteria->addAssociation('categories');
        $criteria->addAssociation('categories.translations');
        $criteria->addAssociation('translations');
        $criteria->addAssociation('properties');
        $criteria->addAssociation('properties.group');
        $criteria->addAssociation('properties.group.translations');
        $criteria->addAssociation('properties.translations');
        $criteria->addAssociation('searchKeywords');
        $criteria->addAssociation('streams.categories');
        $criteria->addAssociation('streams.categories.translations');
        $criteria->addAssociation('price');
        $criteria->addAssociation('prices');
    }
}