<?php

namespace Sisi\Search\ESIndexInterfaces;

/**
 * Interface InterfaceProduktData
 *
 * This interface defines the contract for classes that provide product data settings.
 * Implementations of this interface are responsible for retrieving and formatting
 * settings related to product data for Elasticsearch indexing.
 */
interface InterfaceProduktData
{
    /**
     * Retrieves and processes product data settings.
     *
     * This method takes an array of settings as input and returns an array
     * containing the processed settings. Implementations should define how
     * the settings are retrieved and formatted.
     *
     * @param array $settings The input settings array.
     * @return array The processed settings array.
     */
    public function getSettings(array $settings): array;
}