<?php

namespace Sisi\Search\ESIndexInterfaces;

use Doctrine\DBAL\Driver\Connection;
use Shopware\Core\Content\Media\Pathname\UrlGeneratorInterface;
use Sisi\Search\ESindexing\InsertQuery;
use Symfony\Bridge\Monolog\Logger;
use Elasticsearch\Client;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Interface InterfaceInsertProduktDataIndex
 *
 * This interface defines the contract for classes responsible for indexing product data into Elasticsearch.
 * Implementations should handle the transformation and insertion of product information into the Elasticsearch index.
 */
interface InterfaceInsertProduktDataIndex
{
    /**
     * Sets the index for the given entities.
     *
     * This method is responsible for preparing and inserting product data into the Elasticsearch index.
     * It receives product entities, mapping values, an Elasticsearch client, language ID, logging service,
     * output interface (for console output), parameters, and the container.
     *
     * @param EntitySearchResult $entities The product entities to index. This parameter is passed by reference.
     * @param EntitySearchResult $mappingValues The mapping values for the entities.
     * @param Client $client The Elasticsearch client.
     * @param string $lanugageId The language ID for the entities.
     * @param Logger $loggingService The logging service.
     * @param OutputInterface|null $output The output interface for console output.
     * @param array $parameters Additional parameters.
     * @param ContainerInterface $container The container interface.
     */
    public function setIndex(
        &$entities,
        $mappingValues,
        $client,
        $lanugageId,
        $loggingService,
        $output,
        $parameters,
        $container
    ): void;
}