<?php

namespace Sisi\Search\ESIndexInterfaces;

use Elasticsearch\Client;

/**
 * Interface InterfaceCreateIndex
 *
 * This interface defines the contract for creating indices in Elasticsearch.
 * Implementations should handle the insertion of data into the index.
 */
interface InterfaceCreateIndex
{
    /**
     * Sets up the index and inserts data into it.
     *
     * @param Client $client The Elasticsearch client.
     * @param array $params The parameters for creating the index and inserting data.
     * @return array The response from Elasticsearch.
     */
    public function setInsert(Client $client, array $params): array;
}