<?php

namespace Sisi\Search\ESIndexInterfaces;

use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;

/**
 * Interface InterfaceCreateCriteria
 *
 * This interface defines a contract for classes that need to modify a Criteria object.
 * It provides a method to apply specific criteria modifications.
 */
interface InterfaceCreateCriteria
{
    /**
     * Modifies the given Criteria object.
     *
     * This method allows implementing classes to add specific filters, associations,
     * or other modifications to the provided Criteria object.
     *
     * @param Criteria $criteria The Criteria object to modify. This object is passed by reference,
     *                           allowing modifications to be applied directly.
     */
    public function getCriteria(Criteria &$criteria): void;
}