<?php

declare(strict_types=1);

namespace Sisi\Search\Core\Content\Task\Bundle;

use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

/**
 * Represents a scheduled task entity for managing search indexing processes.
 * This entity stores information about the task, such as its title, execution time,
 * associated shop and language, limits, and status.
 *
 * The class provides properties and methods to manage scheduled tasks within the search indexing process.
 * It includes details such as the task's title, execution time, associated shop and language, limits, and status.
 *
 * @SuppressWarnings(PHPMD.ExcessivePublicCount)
 * @SuppressWarnings(PHPMD.ExcessiveClassComplexity)
 */
class DBSchedularEntity extends Entity
{
    use EntityIdTrait;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var int
     */
    protected $time;



    /**
     * @var int
     */
    protected $days;

    /**
     * @var string
     */
    protected $shop;

    /**
     * @var string
     */
    protected $language;

    /**
     * @var int
     */
    protected $limit;

    /**
     * @var string
     */
    protected $kind;


    /**
     * @var string
     */
    protected $aktive;

    /**
     * @var \DateTimeInterface|null
     */
    protected $lastExecutionTime;

    /**
     * @var \DateTimeInterface
     */
    protected $nextExecutionTime;

    /**
     * @var int
     */
    protected $all;


    /**
     * Returns the title of the scheduled task.
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }
    /**
     * Returns the execution time of the scheduled task.
     */
    public function getTime(): int
    {
        return $this->time;
    }

    /**
     * @param int $time
     */
    public function setTime(int $time): void
    {
        $this->time = $time;
    }

    /**
     * Returns the shop associated with the scheduled task.
     */
    public function getShop(): string
    {
        return $this->shop;
    }

    /**
     * @param string $shop
     */
    public function setShop(string $shop): void
    {
        $this->shop = $shop;
    }

    /**
     * Returns the language associated with the scheduled task.
     */
    public function getLanguage(): string
    {
        return $this->language;
    }

    /**
     * @param string $language
     */
    public function setLanguage(string $language): void
    {
        $this->language = $language;
    }

    /**
     * Returns the limit for the scheduled task.
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     */
    public function setLimit(int $limit): void
    {
        $this->limit = $limit;
    }

    /**
     * Returns the total number of items to be processed by the scheduled task.
     */
    public function getAll(): int
    {
        return $this->all;
    }

    /**
     * @param int $all
     */
    public function setAll(int $all): void
    {
        $this->all = $all;
    }


    /**
     * Returns the last execution time of the scheduled task.
     *
     * @return \DateTimeInterface|null
     */
    public function getLastExecutionTime()
    {
        return $this->lastExecutionTime;
    }

    /**
     * @param \DateTimeInterface|null $lastExecutionTime
     */
    public function setLastExecutionTime(?\DateTimeInterface $lastExecutionTime): void
    {
        $this->lastExecutionTime = $lastExecutionTime;
    }

    /**
     * Returns the next execution time of the scheduled task.
     *
     * @return \DateTimeInterface|null
     */
    public function getNextExecutionTime()
    {
        return $this->nextExecutionTime;
    }

    /**
     * @param \DateTimeInterface $nextExecutionTime
     */
    public function setNextExecutionTime(\DateTimeInterface $nextExecutionTime): void
    {
        $this->nextExecutionTime = $nextExecutionTime;
    }

    /**
     * Returns the kind of the scheduled task.
     */
    public function getKind(): string
    {
        return $this->kind;
    }

    /**
     * @param string $kind
     */
    public function setKind(string $kind): void
    {
        $this->kind = $kind;
    }

    /**
     * Returns the active status of the scheduled task.
     */
    public function getAktive(): string
    {
        return $this->aktive;
    }

    /**
     * @param string $aktive
     */
    public function setAktive(string $aktive): void
    {
        $this->aktive = $aktive;
    }

    /**
     * Returns the number of days for the scheduled task.
     */
    public function getDays(): int
    {
        return $this->days;
    }

    /**
     * @param int $days
     */
    public function setDays(int $days): void
    {
        $this->days = $days;
    }
}