<?php

declare(strict_types=1);

namespace Sisi\Search\Core\Content\Task\Bundle;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\DateTimeField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FloatField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IntField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\TranslatedField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\TranslationsAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;

/**
 * Defines the database schema and structure for the `sisi_search_es_scheduledtask` entity.
 * This class is responsible for defining the fields that make up the entity,
 * their types, and any flags associated with them (e.g., primary key, required).
 *
 * @SuppressWarnings(PHPMD)
 */
class DBSchedularDefinition extends EntityDefinition
{
    /**
     * Returns the entity name.
     *
     * @return string
     */
    public function getEntityName(): string
    {
        return 'sisi_search_es_scheduledtask';
    }

    /**
     * Returns the entity class name.
     *
     * @return string
     */
    public function getEntityClass(): string
    {
        return DBSchedularEntity::class;
    }

    /**
     * Returns the collection class name.
     *
     * @return string
     */
    public function getCollectionClass(): string
    {
        return DBSchedularCollection::class;
    }

    /**
     * Defines the fields for the entity.
     *
     * @return FieldCollection
     */
    protected function defineFields(): FieldCollection
    {
        return new FieldCollection(
            [
                (new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),
                (new StringField('title', 'title'))->addFlags(new Required()),
                (new IntField('time', 'time')),
                (new StringField('shop', 'shop')),
                (new StringField('language', 'language')),
                (new IntField('limit', 'limit')),
                (new IntField('days', 'days')),
                (new IntField('all', 'all')),
                (new StringField('kind', 'kind')),
                (new StringField('aktive', 'aktive')),
                new DateTimeField('last_execution_time', 'lastExecutionTime'),
                (new DateTimeField('next_execution_time', 'nextExecutionTime'))->addFlags(new Required()),
            ]
        );
    }
}