<?php

declare(strict_types=1);

namespace Sisi\Search\Core\Content\Fields\Bundle;

use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;

/**
 * Represents a database entity for managing search fields configuration.
 * This class stores and manages the configuration of individual fields used in the search functionality.
 * It includes properties for defining field types, filters, stemming, tokenization, and other search-related parameters.
 *
 * @package Sisi\Search\Core\Content\Fields\Bundle
 * @SuppressWarnings(PHPMD.ExcessivePublicCount)
 * @SuppressWarnings(PHPMD.ExcessiveClassComplexity)
 * @SuppressWarnings(PHPMD)
 * @codingStandardsIgnoreStart
 */
class DBFieldsEntity extends Entity
{
    use EntityIdTrait;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $fieldtype;


    /**
     * @var string
     */
    protected $tablename;


    /**
     * @var string|null
     */
    protected $shop;


    /**
     * @var string
     */
    protected $format;


    /**
     * @var string
     */
    protected $filter1;


    /**
     * @var string
     */
    protected $filter2;

    /**
     * @var string
     */
    protected $filter3;

    /**
     * @var string
     */
    protected $stemming;


    /**
     * @var string
     */
    protected $stop;


    /**
     * @var string
     */
    protected $stemmingstop;


    /**
     * @var string
     */
    protected $tokenizer;


    /**
     * @var int
     */

    protected $edge;


    /**
     * @var int
     */

    protected $minedge;


    /**
     * @var string
     */

    protected $booster;

    /**
     * @var string
     */

    protected $pattern;

    /**
     * @var string
     */

    protected $strip;


    /**
     * @var string
     */

    protected $strip_str;


    /**
     * @var string
     */
    protected $synonym;


    /**
     * @var string
     */
    protected $fuzzy;

    /**
     * @var string
     */
    protected $maxexpansions;


    /**
     * @var string
     */
    protected $slop;


    /**
     * @var string
     */
    protected $operator;


    /**
     * @var string
     */
    protected $autosynonyms;


    /**
     * @var string
     */
    protected $minimumshouldmatch;

    /**
     * @var string
     */
    protected $prefixlength;


    /**
     * @var string
     */
    protected $lenient;

    /**
     * @var string
     */
    protected $punctuation;


    /**
     * @var string
     */
    protected $whitespace;

    /**
     * @var string
     */

    protected $exclude;


    /**
     * @var string
     */

    protected $merge;

    /**
     * @var string
     */

    protected $prefix;

    /**
     * @var string
     */

    protected $phpfilter;

    /**
     * @var string|null
     */
    protected $shoplanguage;

    /**
     * @var string
     */
    protected $onlymain;


    /**
     * @var string
     */
    protected $excludesearch;




    /**
     * Retrieves the table name associated with this field.
     *
     * @return string The table name.
     */
    public function getTablename(): string
    {
        // ---- Ensure the table name is not null
        if ($this->tablename === null) {
            $this->tablename = '';
        }
        return $this->tablename;
    }

    /**
     * @params tring $tablename
     */
    public function setTablename(string $tablename): void
    {
        $this->tablename = $tablename;
    }

    /**
     * Retrieves the field type.
     *
     * @return string The field type.
     */
    public function getFieldtype(): string
    {
        // ---- Ensure the field type is not null
        if ($this->fieldtype === null) {
            $this->fieldtype = '';
        }
        return $this->fieldtype;
    }


    public function setFieldtype(string $fieldtype): void
    {
        $this->fieldtype = $fieldtype;
    }

    /**
     * Retrieves the tokenizer.
     *
     * @return string The tokenizer.
     */
    public function getTokenizer(): string
    {
        // ---- Ensure the tokenizer is not null
        if ($this->tokenizer === null) {
            $this->tokenizer = '';
        }
        return $this->tokenizer;
    }

    /**
     * @param string $tokenizer
     */
    public function setTokenizer(string $tokenizer): void
    {
        $this->tokenizer = $tokenizer;
    }


    public function getName(): ?string
    {
        if ($this->name === null) {
            $this->name = '';
        }
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Retrieves the shop associated with this field.
     *
     * @return string|null The shop identifier, or null if not set.
     */
    public function getShop(): ?string
    {
        // ---- Ensure the shop is not null
        if ($this->shop == null) {
            $this->shop = '';
        }
        return $this->shop;
    }

    /**
     * @param string|null $shop
     */
    public function setShop(?string $shop): void
    {
        $this->shop = $shop;
    }

    /**
     * Get the value of format
     *
     * @return  string
     */
    public function getFormat()
    {
        // ---- Ensure the format is not null
        if ($this->format === null) {
            $this->format = '';
        }
        return $this->format;
    }

    /**
     * Set the value of format
     *
     * @param string $format
     *
     * @return  self
     */
    public function setFormat(string $format)
    {
        $this->format = $format;
        return $this;
    }

    /**
     * Get the value of filter1
     *
     * @return  string
     */
    public function getFilter1()
    {
        // ---- Ensure the filter1 is not null
        if ($this->filter1 === null) {
            $this->filter1 = '';
        }
        return $this->filter1;
    }

    /**
     * Set the value of filter1
     *
     * @param string $filter1
     *
     * @return  self
     */
    public function setFilter1(string $filter1)
    {
        $this->filter1 = $filter1;
        return $this;
    }

    /**
     * Get the value of filter2
     *
     * @return  string
     */
    public function getFilter2()
    {
        // ---- Ensure the filter2 is not null
        if ($this->filter2 === null) {
            $this->filter2 = '';
        }
        return $this->filter2;
    }


    /**
     * Set the value of filter2
     *
     * @param string $filter2
     *
     * @return  self
     */
    public function setFilter2(string $filter2)
    {
        $this->filter2 = $filter2;

        return $this;
    }

    /**
     * Set the value of filter3
     *
     * @param string $filter3
     *
     * @return  self
     */
    public function setFilter3(string $filter3)
    {
        $this->filter3 = $filter3;

        return $this;
    }

    /**
     * Get the value of filter3
     *
     * @return  string
     */
    public function getFilter3()
    {
        // ---- Ensure the filter3 is not null
        if ($this->filter3 === null) {
            $this->filter3 = '';
        }
        return $this->filter3;
    }


    /**
     * Get the value of stemming
     *
     * @return  string
     */
    public function getStemming()
    {
        // ---- Ensure the stemming is not null
        if ($this->stemming === null) {
            $this->stemming = '';
        }
        return $this->stemming;
    }

    /**
     * Set the value of stemming
     *
     * @param string $stemming
     *
     * @return  self
     */
    public function setStemming(string $stemming)
    {
        $this->stemming = $stemming;

        return $this;
    }

    /**
     * Get the value of stop
     *
     * @return  string
     */
    public function getStop()
    {
        // ---- Ensure the stop is not null
        if ($this->stop === null) {
            $this->stop = '';
        }
        return $this->stop;
    }

    /**
     * Set the value of stop
     *
     * @param string $stop
     *
     * @return  self
     */
    public function setStop(string $stop)
    {
        $this->stop = $stop;

        return $this;
    }

    /**
     * Get the value of stemming
     *
     * @return  string
     */
    public function getStemmingstop()
    {
        // ---- Ensure the stemmingstop is not null
        if ($this->stemmingstop === null) {
            $this->stemmingstop = '';
        }
        return $this->stemmingstop;
    }

    /**
     * Set the value of stemming
     *
     * @param string $stemmingstop
     *
     * @return  self
     */
    public function setStemmingstop(string $stemmingstop)
    {
        $this->stemmingstop = $stemmingstop;

        return $this;
    }

    /**
     * Retrieves the edge value.
     *
     * @return int
     */
    public function getEdge(): int
    {
        return $this->edge;
    }

    /**
     * Sets the edge value.
     *
     * @param int $edge
     */
    public function setEdge(int $edge): void
    {
        $this->edge = $edge;
    }

    /**
     * Retrieves the minedge value.
     *
     * @return int
     */
    public function getMinedge(): int
    {
        return $this->minedge;
    }

    /**
     * Sets the minedge value.
     *
     * @param int $minedge
     */
    public function setMinedge(int $minedge): void
    {
        $this->minedge = $minedge;
    }

    /**
     * Retrieves the booster value.
     *
     * @return string
     */
    public function getBooster(): string
    {
        // ---- Ensure the booster is not null
        if ($this->booster === null) {
            $this->booster = '';
        }
        return $this->booster;
    }

    /**
     * Sets the booster value.
     *
     * @param string $booster
     */
    public function setBooster(string $booster): void
    {
        $this->booster = $booster;
    }

    /**
     * Retrieves the pattern value.
     *
     * @return string
     */
    public function getPattern(): string
    {
        // ---- Ensure the pattern is not null
        if ($this->pattern === null) {
            $this->pattern = '';
        }
        return $this->pattern;
    }

    /**
     * Sets the pattern value.
     *
     * @param string $pattern
     */
    public function setPattern(string $pattern): void
    {
        $this->pattern = $pattern;
    }

    /**
     * Retrieves the strip value.
     *
     * @return string|null
     */
    public function getStrip()
    {
        // ---- Ensure the strip is not null
        if ($this->strip === null) {
            $this->strip = '';
        }
        return $this->strip;
    }

    /**
     * Sets the strip value.
     *
     * @param string $strip
     */
    public function setStrip(string $strip): void
    {
        $this->strip = $strip;
    }

    /**
     * Retrieves the strip_str value.
     *
     * @return string|null
     */
    public function getStrip_str()
    {
        // ---- Ensure the strip_str is not null
        if ($this->strip_str === null) {
            $this->strip_str = '';
        }
        return $this->strip_str;
    }

    /**
     * Sets the strip_str value.
     *
     * @param string $strip_str ;
     */
    public function setStrip_str(string $strip_str): void
    {
        $this->strip_str = $strip_str;;
    }

    /**
     * Retrieves the synonym value.
     *
     * @return string|null
     */
    public function getSynonym()
    {
        // ---- Ensure the synonym is not null
        if ($this->synonym === null) {
            $this->synonym = '';
        }
        return $this->synonym;
    }

    /**
     * Sets the synonym value.
     *
     * @param string $synonym
     */
    public function setSynonym(string $synonym): void
    {
        $this->synonym = $synonym;
    }

    /**
     * Retrieves the fuzzy value.
     *
     * @return string
     */
    public function getFuzzy(): string
    {
        // ---- Ensure the fuzzy is not null
        if ($this->fuzzy === null) {
            $this->fuzzy = '';
        }
        return $this->fuzzy;
    }

    /**
     * Sets the fuzzy value.
     *
     * @param string $fuzzy
     */
    public function setFuzzy(string $fuzzy): void
    {
        $this->fuzzy = $fuzzy;
    }


    /**
     * Retrieves the maxexpansions value.
     *
     * @return string
     */
    public function getMaxexpansions(): string
    {
        // ---- Ensure the maxexpansions is not null
        if ($this->maxexpansions === null) {
            $this->maxexpansions = '';
        }
        return $this->maxexpansions;
    }

    /**
     * Sets the maxexpansions value.
     *
     * @param string $maxexpansions
     */
    public function setMaxexpansions(string $maxexpansions): void
    {
        $this->maxexpansions = $maxexpansions;
    }

    /**
     * Retrieves the slop value.
     *
     * @return string
     */
    public function getSlop(): string
    {
        // ---- Ensure the slop is not null
        if ($this->slop === null) {
            $this->slop = '';
        }
        return $this->slop;
    }

    /**
     * Sets the slop value.
     *
     * @param string $slop
     */
    public function setSlop(string $slop): void
    {
        $this->slop = $slop;
    }

    /**
     * Retrieves the operator value.
     *
     * @return string
     */
    public function getOperator(): string
    {
        // ---- Ensure the operator is not null
        if ($this->operator === null) {
            $this->operator = '';
        }
        return $this->operator;
    }

    /**
     * Sets the operator value.
     *
     * @param string $operator
     */
    public function setOperator(string $operator): void
    {
        $this->operator = $operator;
    }

    /**
     * Retrieves the autosynonyms value.
     *
     * @return string
     */
    public function getAutosynonyms(): string
    {
        // ---- Ensure the autosynonyms is not null
        if ($this->autosynonyms === null) {
            $this->autosynonyms = '';
        }
        return $this->autosynonyms;
    }

    /**
     * Sets the autosynonyms value.
     *
     * @param string $autosynonyms
     */
    public function setAutosynonyms(string $autosynonyms): void
    {
        $this->autosynonyms = $autosynonyms;
    }

    /**
     * Retrieves the minimumshouldmatch value.
     *
     * @return string
     */
    public function getMinimumshouldmatch(): string
    {
        // ---- Ensure the minimumshouldmatch is not null
        if ($this->minimumshouldmatch === null) {
            $this->minimumshouldmatch = '';
        }
        return $this->minimumshouldmatch;
    }

    /**
     * Sets the minimumshouldmatch value.
     *
     * @param string $minimumshouldmatch
     */
    public function setMinimumshouldmatch(string $minimumshouldmatch): void
    {
        $this->minimumshouldmatch = $minimumshouldmatch;
    }

    /**
     * Retrieves the prefixlength value.
     *
     * @return string
     */
    public function getPrefixlength(): string
    {
        // ---- Ensure the prefixlength is not null
        if ($this->prefixlength === null) {
            $this->prefixlength = '';
        }
        return $this->prefixlength;
    }

    /**
     * Sets the prefixlength value.
     *
     * @param string $prefixlength
     */
    public function setPrefixlength(string $prefixlength): void
    {
        $this->prefixlength = $prefixlength;
    }

    /**
     * Retrieves the lenient value.
     *
     * @return string
     */
    public function getLenient(): string
    {
        // ---- Ensure the lenient is not null
        if ($this->lenient === null) {
            $this->lenient = '';
        }
        return $this->lenient;
    }

    /**
     * Sets the lenient value.
     *
     * @param string $lenient
     */
    public function setLenient(string $lenient): void
    {
        $this->lenient = $lenient;
    }

    /**
     * Retrieves the punctuation value.
     *
     * @return string
     */
    public function getPunctuation(): string
    {
        // ---- Ensure the punctuation is not null
        if ($this->punctuation === null) {
            $this->punctuation = '';
        }
        return $this->punctuation;
    }

    /**
     * Sets the punctuation value.
     *
     * @param string $punctuation
     */
    public function setPunctuation(string $punctuation): void
    {
        $this->punctuation = $punctuation;
    }

    /**
     * Retrieves the whitespace value.
     *
     * @return string
     */
    public function getWhitespace(): string
    {
        // ---- Ensure the whitespace is not null
        if ($this->whitespace === null) {
            $this->whitespace = '';
        }
        return $this->whitespace;
    }

    /**
     * Sets the whitespace value.
     *
     * @param string $whitespace
     */
    public function setWhitespace(string $whitespace): void
    {
        $this->whitespace = $whitespace;
    }

    /**
     * Retrieves the exclude value.
     *
     * @return string
     */
    public function getExclude(): string
    {
        // ---- Ensure the exclude is not null
        if ($this->exclude === null) {
            $this->exclude = '';
        }
        return $this->exclude;
    }

    /**
     * Sets the exclude value.
     *
     * @param string $exclude
     */
    public function setExclude(string $exclude): void
    {
        $this->exclude = $exclude;
    }

    /**
     * Retrieves the merge value.
     *
     * @return string
     */
    public function getMerge(): string
    {
        // ---- Ensure the merge is not null
        if ($this->merge === null) {
            $this->merge = '';
        }
        return $this->merge;
    }

    /**
     * Sets the merge value.
     *
     * @param string $merge
     */
    public function setMerge(string $merge): void
    {
        $this->merge = $merge;
    }

    /**
     * Retrieves the prefix value.
     *
     * @return string|null
     */
    public function getPrefix(): ?string
    {
        // ---- Ensure the prefix is not null
        if ($this->prefix === null) {
            $this->prefix = '';
        }
        return $this->prefix;
    }

    /**
     * Sets the prefix value.
     *
     * @param string|null $prefix
     */
    public function setPrefix(?string $prefix): void
    {
        $this->prefix = $prefix;
    }

    /**
     * Retrieves the phpfilter value.
     *
     * @return string
     */
    public function getPhpfilter(): string
    {
        // ---- Ensure the phpfilter is not null
        if ($this->phpfilter === null) {
            $this->phpfilter = '';
        }
        return $this->phpfilter;
    }

    /**
     * Sets the phpfilter value.
     *
     * @param string $phpfilter
     */
    public function setPhpfilter(string $phpfilter): void
    {
        $this->phpfilter = $phpfilter;
    }

    /**
     * Retrieves the shoplanguage value.
     *
     * @return string|null
     */
    public function getShoplanguage(): ?string
    {
        // ---- Ensure the shoplanguage is not null
        if ($this->shoplanguage == null) {
            $this->shoplanguage = '';
        }
        return $this->shoplanguage;
    }

    /**
     * Sets the shoplanguage value.
     *
     * @param string|null $shoplanguage
     */
    public function setShoplanguage(?string $shoplanguage): void
    {
        if ($this->shoplanguage == null) {
            $this->shoplanguage = '';
        }
        $this->shoplanguage = $shoplanguage;
    }
    /**
     * Retrieves the onlymain value.
     *
     * @return string
     */
    public function getOnlymain(): string
    {
        return $this->onlymain;
    }

    /**
     * Sets the onlymain value.
     *
     * @param string $onlymain
     */
    public function setOnlymain(string $onlymain): void
    {
        $this->onlymain = $onlymain;
    }

    /**
     * Retrieves the excludesearch value.
     *
     * @return string
     */
    public function getExcludesearch(): ?string
    {
        return $this->excludesearch;
    }

    /**
     * Sets the excludesearch value.
     *
     * @param string $excludesearch
     */
    public function setExcludesearch(?string $excludesearch): void
    {
        $this->excludesearch = $excludesearch;
    }
}