<?php

declare(strict_types=1);

namespace Sisi\Search\Core\Content\Fields\Bundle;

use Shopware\Core\Framework\DataAbstractionLayer\EntityCollection;

/**
 * Represents a collection of DBFieldsEntity objects.
 *
 * This class extends the EntityCollection class from the Shopware Core Framework
 * and is designed to hold and manage a collection of DBFieldsEntity objects.
 * It provides type-safe access to the entities within the collection.
 *
 * @method void              add(DBFieldsEntity $entity)
 * @method void              set(string $key, DBFieldsEntity $entity)
 * @method DBFieldsEntity[]    getIterator()
 * @method DBFieldsEntity[]    getElements()
 * @method DBFieldsEntity|null get(string $key)
 * @method DBFieldsEntity|null first()
 * @method DBFieldsEntity|null last()
 */
class DBFieldsCollection extends EntityCollection
{
    /**
     * Retrieves the expected class name for the entities within this collection.
     *
     * This method is used internally by the EntityCollection to ensure that only
     * entities of the correct type are added to the collection.
     *
     * @return string The class name of the expected entity (DBFieldsEntity::class).
     */
    protected function getExpectedClass(): string
    {
        return DBFieldsEntity::class;
    }
}