<?php

declare(strict_types=1);

namespace Sisi\Search\Controller;

use Doctrine\DBAL\Connection;
use mysql_xdevapi\Exception;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Routing\Annotation\RouteScope;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Sisi\Search\Service\BackendStatisticsService;
use Sisi\Search\Service\ClientService;
use Sisi\Search\Service\ContextService;
use Sisi\Search\Service\QuerylogService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Sisi\Search\Service\BackendIndexService;

/**
 * @RouteScope(scopes={"api"})
 *
 * This class is a controller that handles requests related to search dashboards.
 * It provides functionalities such as retrieving query history.
 */
class DashController extends AbstractController
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    protected SystemConfigService $config;

    /**
     * @var Connection
     */
    protected $connection;

    /**
     * Constructor for the DashController.
     *
     * @param ContainerInterface $container The Symfony container.
     * @param SystemConfigService $config The system configuration service.
     * @param Connection $connection The database connection.
     */
    public function __construct(ContainerInterface $container, SystemConfigService $config, Connection $connection)
    {
        $this->container = $container;
        $this->config = $config;
        $this->connection = $connection;
    }

    /**
     * Retrieves the query history based on the provided request.
     *
     * @Route("api/_action/sisi/sisisearch/history", name="api.action.sisisearch.history", methods={"POST"})
     *
     * @param Request $request The HTTP request.
     *
     * @return JsonResponse The JSON response containing the query history.
     */
    public function getQueryhistory(Request $request): JsonResponse
    {
        // ---- Get the SisiSearch configuration
        $config = $this->config->get("SisiSearch.config");

        // ---- Initialize services
        $heandlerClient = new ClientService();
        $heandlerBackendStatistics = new BackendStatisticsService();
        $heandlerQuerlog = new QuerylogService();

        // ---- Create a client instance
        $client = $heandlerClient->createClient($config);

        // ---- Decode the request content
        $result = (array)json_decode($request->getContent());
        $result = (array)$result['config'];
        $resultArray = explode("_", $result['channel']);

        // ---- Retrieve the sales channel item
        try {
            $saleschannelItem = $heandlerQuerlog->findAll($this->connection, $resultArray[0]);
        } catch (\Exception $e) {
            echo $e->getMessage();
        }

        $saleschannelItem['languageId'] = $resultArray[1];

        // ---- Get the history from the backend statistics service
        $elasticvalue[] = $heandlerBackendStatistics->getHistory($config, $client, $saleschannelItem);

        return new JsonResponse($elasticvalue);
    }
}