<?php declare(strict_types=1);

namespace Sisi\Search\Constants;

/**
 * Contains constants for the plugin configuration keys.
 * ! THIS FILE IS AUTO-GENERATED ! Do not edit this file directly !
 * Generated by: Topdata\TopdataDevelopmentHelperSW6\Command\GenerateConfigConstantsCommand
 * Generated at: 2025-06-19 16:56:28
 */
final class ConfigKeyConstants
{
    /**
     * Label: Product presentation - Number of columns in the Ajax result list
     *
     * @default 2
     *
     * @options Available choices:
     * - 1: 1 column
     * - 2: 2 columns
     * - 3: 3 columns
     * - 4: 4 columns
     * - 6: 6 column
     */
    public const COLS_AJAX = 'ColsAjax';

    /**
     * Label: You use Elasticcloud
     *
     * @default 'best_fields'
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const ELASTICCLOUD = 'Elasticcloud';

    /**
     * Label: Image size in the Ajax result list
     *
     * @default 0
     *
     * @options Available choices:
     * - 1: large
     * - 0: small
     */
    public const IMAGE_SIZE = 'ImageSize';

    /**
     * Label: Include inactive products in the index (Only works with a extend Plugin)
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const ADD_INAKTIVE = 'addInaktive';

    /**
     * Label: Add the product numbers of the variants to the search keywords
     *
     * @options Available choices:
     * - 'yes': yes
     * - 'no': no
     */
    public const ADD_PRODUCT_NUMBER = 'addProductNumber';

    /**
     * Label: If you only index main items, the variants can be indexed and searched as
     * sub-products
     *
     * @options Available choices:
     * - 'yes': yes
     * - 'individual': Variants as a sub-product but try to take the individual product setting from listing by the index process
     * - 'no': no
     */
    public const ADD_VARIANTS = 'addVariants';

    /**
     * Label: Use the own app ajax search controller
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const AJAXCONTROLLER = 'ajaxcontroller';

    /**
     * Label: Background color of the category list in the Ajax box
     */
    public const BACKGROUND_COLOR_COL1 = 'backgroundColorCol1';

    /**
     * Label: Footer background color of the Ajax result list
     */
    public const BACKGROUND_COLORBOTTOM = 'backgroundColorbottom';

    /**
     * Label: Background color - Ajax result list
     */
    public const BACKGROUND_MAIN = 'backgroundMain';

    /**
     * Label: AJAX presentation - layout
     *
     * @default 2
     *
     * @options Available choices:
     * - 1: Default
     * - 2: Boxes
     */
    public const BOX_AJAX = 'boxAjax';

    /**
     * Label: Width of Ajax result list in % relative to screen width
     *
     * @default 80
     */
    public const BOXWITH = 'boxwith';

    /**
     * Label: Config for the breadcrumb deep
     *
     * @default '/'
     */
    public const BREADCRUMB_DEPTH = 'breadcrumbDepth';

    /**
     * Label: If you use breadcrumb you can add der separator symbol
     *
     * @default '/'
     */
    public const BREADCRUMBSEPARATOR = 'breadcrumbseparator';

    /**
     * Label: (beta) Prices for older shop versions
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const CALCULATEDOLD = 'calculatedold';

    /**
     * Label: (beta) Show calculated prices in the ajaxpopup
     *
     * @options Available choices:
     * - 1: Yes
     * - 3: Orginal price
     * - 2: No
     */
    public const CALCULATEDPRICES = 'calculatedprices';

    /**
     * Label: Show categories
     *
     * @default 6
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     * - 3: Categories not as filters but as search results
     * - 4: Categories by the products
     * - 5: Display categorie only as filter
     * - 6: Categorie with own index
     * - 7: Categorie with own index and filter
     * - 8: Categorie with own index and in the products
     */
    public const CATEGORIEN = 'categorien';

    /**
     * Label: If you have selected the categories in own index, you can exclude categories here.
     */
    public const CATEGORYNOININDEX = 'categorynoinindex';

    /**
     * Label: If you have selected the categories in own index, you can exclude categories with
     * one Id every row
     */
    public const CATEGORYNOININDEXBY_ID = 'categorynoinindexbyId';

    /**
     * Label: Use the cheapest price
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const CHEAPEST_PRICE = 'cheapestPrice';

    /**
     * Label: Please check if the product name is different. If so, display the product in the
     * listing.
     *
     * @options Available choices:
     * - 'yes': yes
     * - 'no': no
     */
    public const CHECKVARIANTS_NAME = 'checkvariantsName';

    /**
     * Label: The step size when indexing variants. (Default 100)
     *
     * @default 100
     */
    public const CHILDSTEPSIZE = 'childstepsize';

    /**
     * Label: Elasticcloud id
     */
    public const CLOUDID = 'cloudid';

    /**
     * Label: The Language Id from the Products
     */
    public const CONFIG_LANGUAGE = 'configLanguage';

    /**
     * Label: The Language Id from Index
     */
    public const CONFIG_LANGUAGE_INDEX = 'configLanguageIndex';

    /**
     * Label: Display the default price
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DEFAULTPRICE = 'defaultprice';

    /**
     * Label: Disable the the Ajax Popup
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABABLE_AJAX = 'disabableAjax';

    /**
     * Label: Disable count result
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLE_COUNT = 'disableCount';

    /**
     * Label: Do not show produkt description
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISABLE_DESCRIPTION = 'disableDescription';

    /**
     * Label: Remove filterlink from the Ajax Popup
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLE_FILTERLINK = 'disableFilterlink';

    /**
     * Label: Hide the link Show search results
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLE_LINKRESULT = 'disableLinkresult';

    /**
     * Label: Display product number
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLE_NUMBER = 'disableNumber';

    /**
     * Label: Do not show snippets hist
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISABLE_SNIPPET = 'disableSnippet';

    /**
     * Label: Hide the manufacturer in the template
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISABLEBRANDSFRONTEND = 'disablebrandsfrontend';

    /**
     * Label: Don't show the category hit for the products
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLECATEGORYBYTHEPRODUCTS = 'disablecategorybytheproducts';

    /**
     * Label: Shopware keywords are not displayed in the template
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISABLEKEYWORDSFRONTEND = 'disablekeywordsfrontend';

    /**
     * Label: Disable manufacturer number
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLEMANUFACTURER_NUMBER = 'disablemanufacturerNumber';

    /**
     * Label: Don't use the word product as a label in Ajaxpop
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const DISABLEPRODUKTLABEL = 'disableproduktlabel';

    /**
     * Label: Show breadcrumb (Only works with the category in own index setting)
     *
     * @default 1
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISPLAYBREADCRUMB = 'displaybreadcrumb';

    /**
     * Label: Hits highlighting
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     * - 3: Hits highlighting with more fields in the product name
     */
    public const DISPLAYHIGHLIGHT = 'displayhighlight';

    /**
     * Label: Display the highlighting for the product name
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const DISPLAYPRODUCTHIGHLIGHT = 'displayproducthighlight';

    /**
     * Label: (Only by Autocomplete Filter) max edge Value
     *
     * @default 10
     */
    public const EDGE = 'edge';

    /**
     * Label: Elasticsearch available
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const ELASTICSEARCH_AKTIVE = 'elasticsearchAktive';

    /**
     * Label: Search page desktop columns
     *
     * @options Available choices:
     * - 12: 1
     * - 6: 2
     * - 4: 3
     * - 3: 4
     * - 2: 6
     */
    public const ELASTICSEARCH_DESKTOP_VIEW = 'elasticsearchDesktopView';

    /**
     * Label: Search page mobile columns
     *
     * @options Available choices:
     * - 12: 1
     * - 6: 2
     */
    public const ELASTICSEARCH_MOBILE_VIEW = 'elasticsearchMobileView';

    /**
     * Label: Search page tablet columns
     *
     * @options Available choices:
     * - 12: 1
     * - 6: 2
     * - 4: 3
     * - 3: 4
     */
    public const ELASTICSEARCH_TABLET_VIEW = 'elasticsearchTabletView';

    /**
     * Label: The extra query for the filter memory optimizes but may be slower
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const EXTRAQUERXMENORY = 'extraquerxmenory';

    /**
     * Label: If you have selected the extra query for filters, you can enter the query size here
     *
     * @default 30
     */
    public const EXTRAQUERY_SIZEFORFILTER = 'extraquerySizeforfilter';

    /**
     * Label: Extra query for filters
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const EXTRAQUERYFORFILTERS = 'extraqueryforfilters';

    /**
     * Label: Fuzzy for the filter.
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const FILTER_FUZZY = 'filterFuzzy';

    /**
     * Label: Show filter open after query
     *
     * @options Available choices:
     * - 'no': No
     * - 'yes': Yes
     */
    public const FILTER_OPEN = 'filterOpen';

    /**
     * Label: Filter in relation to search query
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const FILTER_TO_SEARCH = 'filterToSearch';

    /**
     * Label: But filter groups name what you whant to use
     */
    public const FILTERFILTER = 'filterfilter';

    /**
     * Label: Disable the filter on the result page
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const FILTERONPAGERESULT = 'filteronpageresult';

    /**
     * Label: Filter scrolling enable (disable paging)
     *
     * @default 'ajax'
     *
     * @options Available choices:
     * - 'yes': Yes (scrolling)
     * - 'ajax': Change paging to Ajax
     * - 'noget': Change paging to Ajax without browser history
     * - 'no': No
     */
    public const FILTERSCROLLING = 'filterscrolling';

    /**
     * Label: Disable filter scrolling on ajax popup
     *
     * @default 'ajax'
     *
     * @options Available choices:
     * - 'yes': Yes (scrolling)
     * - 'no': No
     */
    public const FILTERSCROLLING_POPUP = 'filterscrollingPopup';

    /**
     * Label: Get all filter
     *
     * @options Available choices:
     * - 'no': No
     * - 'yes': Yes
     */
    public const FILTERTYPE = 'filtertype';

    /**
     * Label: Font color in the Ajax result list
     */
    public const FONT_COLOR = 'fontColor';

    /**
     * Label: Font color the category list (left side)
     */
    public const FONT_COLOR_COL1 = 'fontColorCol1';

    /**
     * Label: Footer font color of the Ajax result list
     */
    public const FONT_COLORBOTTOM = 'fontColorbottom';

    /**
     * Label: Font color of the Ajax result list header
     */
    public const FONT_COLORHEADER = 'fontColorheader';

    /**
     * Label: Font color of the search words in the Ajax result list - highlighting
     */
    public const FONT_COLORHIGHT = 'fontColorhight';

    /**
     * Label: Font color of the search words in the Ajax result list - highlighting (left side)
     */
    public const FONT_COLORHIGHT_COL1 = 'fontColorhightCol1';

    /**
     * Label: Number of letters/characters are allowed in the search field.
     *
     * @default 30
     */
    public const FORM = 'form';

    /**
     * Label: Fragment size for the hightlighting
     */
    public const FRAGMENTSIZE = 'fragmentsize';

    /**
     * Label: If you have set the filter query to memory optimized, you can set the step size of
     * the recursive calls here
     *
     * @default 30
     */
    public const FRAGMENTSIZE_RECURSIVE = 'fragmentsizeRecursive';

    /**
     * Label: Fragment size for the hightlighting when you use the the own categorie query
     */
    public const FRAGMENTSIZECATEGORIE = 'fragmentsizecategorie';

    /**
     * Label: Fragment size for the recommender query
     */
    public const FRAGMENTSIZERECOMMENDER = 'fragmentsizerecommender';

    /**
     * Label: Gram size (default 20)
     *
     * @default 20
     */
    public const GRAMSIZE = 'gramsize';

    /**
     * Label: Elasticsearch hosts (example:http://localhost:9200) (every row a host)
     */
    public const HOST = 'host';

    /**
     * Label: Show manufacturer
     *
     * @default 1
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     * - 3: Display by the products
     */
    public const MANUFACTURER = 'manufacturer';

    /**
     * Label: max_ngram_diff (Max diff for the edge Tokenizer)
     *
     * @default 10
     */
    public const MAXNGRAMDIFF = 'maxngramdiff';

    /**
     * Label: max shingle size (Max diff for the Suggest Filter)
     *
     * @default 10
     */
    public const MAXSHINGLEDIFF = 'maxshinglediff';

    /**
     * Label: max shingle size
     *
     * @default 10
     */
    public const MAXSHINGLESIZE = 'maxshinglesize';

    /**
     * Label: minScore for the products
     */
    public const MIN_SCORE = 'minScore';

    /**
     * Label: minScore for the filters
     */
    public const MIN_SCORE_FILTER = 'minScoreFilter';

    /**
     * Label: (Only by Autocomplete Filter) min edge Value
     *
     * @default 3
     */
    public const MINEDGE = 'minedge';

    /**
     * Label: Mini should match (Only works with the mostfield query)
     */
    public const MINISHOULDMATCH = 'minishouldmatch';

    /**
     * Label: min shingle size (Default 2)
     *
     * @default 2
     */
    public const MINSHINGLESIZE = 'minshinglesize';

    /**
     * Label: Includes only the main products in the index (without variants)
     *
     * @options Available choices:
     * - 'yes': yes
     * - 'stock': Yes but check the stock from every variant
     * - 'nodouple': Do not index duplicate product names
     * - 'nostock': If stock is 0 don't index the products
     * - 'nostockandmain': Only main products with Stock
     * - 'variants': Only index variants without the virtual main article
     * - 'no': no
     */
    public const ONLYMAIN = 'onlymain';

    /**
     * Label: Popup optik 1 to 2
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const OPTIK = 'optik';

    /**
     * Label: (beta) Direct output from the ES result on thesearch results page
     *
     * @options Available choices:
     * - 1: Yes
     * - 3: Yes with shopware price
     * - 2: No
     */
    public const OUTPUTKIND = 'outputkind';

    /**
     * Label: A separate query for the Ajaxpopup filter if you set a value greater than 0 and if
     * you have selected the Sorted properties setting above
     *
     * @default 0
     */
    public const OWN_FILTERQUERY = 'ownFilterquery';

    /**
     * Label: Elasticcloud password
     */
    public const PASSWORD = 'password';

    /**
     * Label: Pad to your php cli (for your backend indexing)
     */
    public const PHP_PAD = 'phpPad';

    /**
     * Label: Height of Ajax result in rem. It should not be set too large so that scrolling is
     * possible
     *
     * @default 20
     */
    public const POPUPHEIGHT = 'popupheight';

    /**
     * Label: Distance from top (in pixel) for desktop. Afterwards please check all viewports.
     */
    public const POSITION = 'position';

    /**
     * Label: Distance from top (in pixel) for smartphone. Afterwards please check all viewports.
     */
    public const POSITION_MOBILE = 'positionMobile';

    /**
     * Label: Distance from top (in pixel) for tablet. Afterwards please check all viewports.
     */
    public const POSITION_TABLET = 'positionTablet';

    /**
     * Label: Distance from top (in pixel) for smartphone (very small). Afterwards please check
     * all viewports.
     */
    public const POSITION_X_S_MOBILE = 'positionXSMobile';

    /**
     * Label: Prefix for the index name
     */
    public const PREFIX = 'prefix';

    /**
     * Label: Prefix for the Shopware keyword search field. Prefix for the Shopware keyword
     * search field. can only be used if the product name was created again with the prefix
     */
    public const PREFIXSEARCHKEYWORT = 'prefixsearchkeywort';

    /**
     * Label: Enable filters for prices on the search result page
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const PRICE_FILTERON = 'priceFilteron';

    /**
     * Label: Number of hits to display in the Ajax result list (If you want infinite scrolling
     * you have to increase the number of hits)
     *
     * @default 30
     */
    public const PRODUCTHITS = 'producthits';

    /**
     * Label: Number of hits to display in the product result list page
     *
     * @default 10
     */
    public const PRODUCTHITS_SEARCH = 'producthitsSearch';

    /**
     * Label: Show Properties
     *
     * @default 1
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     * - 3: Display by the products
     */
    public const PROPERTIES = 'properties';

    /**
     * Label: Types of multi_match for products query (example
     * https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-multi-match-query.html)
     *
     * @default 'best_fields'
     *
     * @options Available choices:
     * - 'best_fields': best_fields
     * - 'most_fields': most_fields
     * - 'phrase': phrase
     * - 'phrase_prefix': phrase_prefix
     * - 'and_bool_query': bool_query (The term must appear in the product name while all related fields are linked using OR)
     */
    public const QUERYKIND = 'querykind';

    /**
     * Label: (beta) Query log on (The mapping must first be created using the command php
     * bin/console sisi-log-index:mapping shop="Channel Name")
     *
     * @default 'best_fields'
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const QUERYLOG = 'querylog';

    /**
     * Label: Turn off query log result in frontend
     *
     * @default 'best_fields'
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const QUERYLOG_DISABLEIN_FRONTEND = 'querylogDisableinFrontend';

    /**
     * Label: Number of suggestions
     *
     * @default 5
     */
    public const QUERYLOGSIZE = 'querylogsize';

    /**
     * Label: Query size for the recommender
     */
    public const QUERYSIZERECOMMENDER = 'querysizerecommender';

    /**
     * Label: Enable filters for ratings on the search results page
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const RATING_FILTERON = 'ratingFilteron';

    /**
     * Label: Here, you remove unwanted text from the "Breadcrumb" category.
     *
     * Help: To configure this setting, you need to enable one of the following options under the
     * "Category" section: Categorie with Own Index, Categorie with Own Index and Filte or
     * Categorie with Own Index and in the Products
     */
    public const REMOVE_BREADCRUMB = 'removeBreadcrumb';

    /**
     * Label: Realtion field for filter on the search result page.
     */
    public const RESULTPAGE = 'resultpage';

    /**
     * Label: Use the own app search controller
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const SEARCHCONTROLLER = 'searchcontroller';

    /**
     * Label: Uses the Shopware Searchkey words as synonyms
     *
     * @options Available choices:
     * - 1: Yes
     * - 3: Yes adds the keywords to the product name
     * - 2: No
     */
    public const SEARCHKEYWORT = 'searchkeywort';

    /**
     * Label: Which Shopware layout on the search results page
     *
     * @default 'standard'
     *
     * @options Available choices:
     * - 'standard': standard
     * - 'minimal': minimal
     * - 'image': box-image
     * - 'wishlist': box-wishlist
     */
    public const SEARCHLAYOUT = 'searchlayout';

    /**
     * Label: If you have chosen the option to use categories in your own index, you can specify
     * here the categories ids that should be used
     */
    public const SELECT_CATEGORIE = 'selectCategorie';

    /**
     * Label: Show the insert
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const SHOWINSERT = 'showinsert';

    /**
     * Label: AJAX presentation - filter and product boxes
     *
     * @default 2
     *
     * @options Available choices:
     * - 1: Filter left, products right
     * - 2: Products left, filter right
     */
    public const SIDEBAR_AJAX = 'sidebarAjax';

    /**
     * Label: If you selected the (Check the stock) above. Can you remove the main product from
     * the calculation here?
     *
     * @options Available choices:
     * - 'yes': yes
     * - 'no': no
     */
    public const STOCKWITHOUTMAIN = 'stockwithoutmain';

    /**
     * Label: Storefront api yes or no
     *
     * @default 'best_fields'
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const STOREFRONTAPI = 'storefrontapi';

    /**
     * Label: Add only the images in the ESindex (improves the performance if not all data are
     * required)
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const STRCHANNEL = 'strchannel';

    /**
     * Label: If you set this to yes, the variants will be included in the Es server, which will
     * certainly lead to an error message. The setting is intended for developers who want to
     * work with the data in an external plugin
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const STRCHILDREN = 'strchildren';

    /**
     * Label: Turn off the automatic product delete event
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const STRDELETEPRODUCT = 'strdeleteproduct';

    /**
     * Label: Uses the index only after full re-indexing
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const STRINDEXFINISH = 'strindexfinish';

    /**
     * Label: strip (removing any special characters)
     */
    public const STRIP = 'strip';

    /**
     * Label: Turn on the automatic index update event (Please use this setting with great
     * caution and test the function for saving the products in the backend)
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const STRYNC = 'strync';

    /**
     * Label: The channel IDs or language IDs can be excluded here, e.g. the headless channel
     */
    public const STRYNCEXCLUDE = 'stryncexclude';

    /**
     * Label: Display suggest
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const SUGGEST = 'suggest';

    /**
     * Label: Suggest mode (default always)
     *
     * @options Available choices:
     * - 'missing': Missing
     * - 'popular': Popular
     * - 'always': Always
     */
    public const SUGGESTMODE = 'suggestmode';

    /**
     * Label: Suggestions not as a filter but under the search form. This setting also applies to
     * the Query Recommender
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const SUGGESTPLACE = 'suggestplace';

    /**
     * Label: Suggest size (default 1)
     *
     * @default 1
     */
    public const SUGGESTSIZE = 'suggestsize';

    /**
     * Label: Synonyms (example
     * https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis-synonym-tokenfilter.html)
     */
    public const SYNOM = 'synom';

    /**
     * Label: Path for your own Ajax result list template (example
     * @Storefront/storefront/layout/header/search-suggest-test.html.twig)
     */
    public const THEME_E_S = 'themeES';

    /**
     * Label: Individual thumbnail size (example: 400x400)
     */
    public const THUMBNAILS_I_D = 'thumbnailsID';

    /**
     * Label: Products tie_breaker values range (0...1) (example 0.7)
     */
    public const TIEBREAKER = 'tiebreaker';

    /**
     * Label: Limit of total fields
     */
    public const TOTALFIELDS = 'totalfields';

    /**
     * Label: Limit of total child
     */
    public const TOTALNESTED = 'totalnested';

    /**
     * Label: Url for the images
     */
    public const URL_IMAGE = 'urlImage';

    /**
     * Label: Use Shopware's native search keywords
     *
     * Help: If set to 'Yes', keywords from the 'Search keywords' field in the product settings
     * will be added to the 'search_keyword' field in the index.
     *
     * @default 'no'
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const USE_SHOPWARE_SEARCH_KEYWORDS = 'useShopwareSearchKeywords';

    /**
     * Label: We only need it when using the Dynamic Access plugin (Only works with a extend
     * Plugin)
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const USEDYNAMICACCESS = 'usedynamicaccess';

    /**
     * Label: Use Prefix for Categorie Index
     *
     * @default 6
     *
     * @options Available choices:
     * - 1: Yes
     * - 2: No
     */
    public const USEPREFIXFORCATEGORIE = 'useprefixforcategorie';

    /**
     * Label: Elasticloud user name
     */
    public const USER = 'user';

    /**
     * Label: Hide the prices in the popup using the B2BSeller
     *
     * @options Available choices:
     * - 'yes': Yes
     * - 'no': No
     */
    public const WITHOUTLOGIN = 'withoutlogin';
}
