<?php

namespace Sisi\Search\Components;

use Doctrine\DBAL\Statement;
use Sisi\Search\Service\ContextService;
use Doctrine\DBAL\Connection;

/**
 * This class is responsible for retrieving manufacturer information from the database.
 * It provides methods to fetch manufacturer names based on their IDs.
 */
class ManufactoryService
{
    /**
     * Retrieves the name of a manufacturer by its ID.
     *
     * @param Connection $connection The database connection.
     * @param string|null $manufactoryId The ID of the manufacturer.
     * @return string The name of the manufacturer.
     */
    public function getManufactoryById(Connection $connection, $manufactoryId): string
    {
        $contextService = new ContextService();

        // ---- Build the database query
        $query = $connection->createQueryBuilder()
            ->select(['product_manufacturer_translation.name'])
            ->from('product_manufacturer_translation')
            ->where('product_manufacturer_translation.product_manufacturer_id =:id')
            ->setParameter(':id', $contextService->getFromHexToBytes($manufactoryId));

        // ---- Execute the query
        /** @var Statement $result */
        $result = $query->execute();

        // ---- Return the manufacturer name
        return $result->fetchColumn();
    }
}