<?php

namespace Sisi\Search\Components;

use Doctrine\DBAL\Statement;
use Sisi\Search\Service\ContextService;
use Doctrine\DBAL\Connection;

/**
 * This class provides methods to retrieve category information from the database.
 */
class CategoryService
{
    /**
     * Retrieves the name of a category by its ID.
     *
     * @param Connection $connection The database connection.
     * @param string $catergorieId The ID of the category.
     * @return string|null The name of the category, or null if not found.
     */
    public function getCategorieNameById(Connection $connection, $catergorieId)
    {
        // ---- Create a new ContextService instance
        $contextService = new ContextService();

        // ---- Build the database query
        $query = $connection->createQueryBuilder()
            ->select(['translation.name'])
            ->from('category')
            ->innerJoin('category', 'category_translation', 'translation', 'translation.category_id =category.id')
            ->where('category.id =:id')
            ->setParameter(':id', $contextService->getFromHexToBytes($catergorieId));

        // ---- Execute the query and fetch the result
        /** @var Statement $result */
        $result = $query->execute();
        return $result->fetchColumn();
    }
}