<?php

namespace Sisi\Search\Commands;

use Doctrine\DBAL\Connection;
use Sisi\Search\Components\CliStyle;
use Sisi\Search\Service\DeleteInaktiveService;
use Sisi\Search\Service\TextService;
use Sisi\Search\Util\CliLogger;
use Symfony\Bridge\Monolog\Logger;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * This class represents a console command to delete inactive products from the Elasticsearch server.
 * It allows specifying shop, shop ID, and language to target specific indexes for deletion.
 */
class Command_DeleteInactiveProducts extends Command
{
    protected static $defaultName = 'sisi-Produkt-inaktive:delete';


    protected SystemConfigService $config;


    /**
     * @var Connection
     */
    protected $connection;


    /**
     * @var Logger
     */
    private $logger;


    /**
     * @var ContainerInterface
     */
    protected $container;


    public function __construct(
        SystemConfigService $config,
        Connection          $connection,
        Logger              $logger,
        ContainerInterface  $container
    )
    {
        parent::__construct();
        $this->config = $config;
        $this->connection = $connection;
        $this->logger = $logger;
        $this->container = $container;
    }


    /**
     * Configures the command by defining its name, description, and arguments.
     */
    protected function configure(): void
    {
        $this->addArgument('shop', InputArgument::OPTIONAL, 'shop Channel');
        $this->addArgument('shopID', InputArgument::OPTIONAL, 'shop Channel id');
        $this->addArgument(
            'all',
            InputArgument::OPTIONAL,
            'Delete all Indexes without the last Indexes. Add the nummber what no want to delete'
        );
        $this->addArgument(
            'language',
            InputArgument::OPTIONAL,
            'With this parameters you only delete indexing from this language'
        );
        $this->addArgument(
            'languageID',
            InputArgument::OPTIONAL,
            'This parameter is necessary when you want use not the default language and you know the language id'
        );
        $this->setDescription('Delete all inactive products from the Elasticsearch Server');
    }

    /**
     * Executes the command to delete inactive products from Elasticsearch.
     *
     * @param InputInterface $input The input interface.
     * @param OutputInterface $output The output interface.
     * @return int|null
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // ---- Initialize services
        CliLogger::setCliStyle(new CliStyle($input, $output));
        $delteheandler = new DeleteInaktiveService();
        $arguments = $input->getArguments();
        $textService = new TextService();

        // ---- Prepare parameters for deletion
        $parameters = $textService->stripOption($arguments);
        $parameters['shop'] = $input->getArgument('shop');
        if (strpos($parameters['shop'], 'language') !== false) {
            $parameters['shopID'] = $input->getArgument('shopID');
        }
        $parameters['type'] = 'inaktive';

        // ---- Execute the deletion process
        $delteheandler->deleteIndex($parameters, $output, $this->connection, $this->config, $this->logger, $this->container);
        return 0;
    }
}