# Sisi Produkt Inaktive Delete Command

## Command Name
`sisi-Produkt-inaktive:delete`

## Purpose
Deletes inactive products from Elasticsearch indexes. Allows targeting specific shops, languages, or indexes while maintaining operational flexibility. This command is essential for:
- Removing discontinued or hidden products from search results
- Freeing up Elasticsearch resources by cleaning obsolete indexes
- Maintaining search relevance by excluding inactive items

## CLI Arguments

### Arguments
| Argument | Required | Default | Description |
|----------|----------|---------|-------------|
| `shop` | No | - | Sales channel name (target specific shop). When shop name contains "language", shopID becomes required |
| `shopID` | Conditional | - | Sales channel ID (required when shop name contains 'language') |
| `all` | No | - | Delete all indexes except the last N (specify N) |
| `language` | No | - | Delete only indexes for this language (e.g., "en-GB") |
| `languageID` | No | - | Language ID (UUID) for non-default languages |

## Parameter Handling

### Shop Parameters
The `shop` and `shopID` arguments work together:
- **Normal Shops**:
  - Only `shop` parameter needed (e.g., `--shop=main_store`)
- **Language-Specific Shops**:
  - When shop name contains "language" (e.g., `--shop=language_shop`)
  - Requires `shopID` parameter to be provided
  - Example: `--shop=language_shop --shopID=abc123`

### Language Parameters
The command provides flexible language targeting:
- **Language Parameters**:
  - `language`: Targets indexes by language code (e.g., "en-GB")
  - `languageID`: Targets indexes by Shopware language UUID
- **Behavior**:
  - When both language parameters omitted: Targets default language indexes
  - When both provided: Validates that languageID matches language code

## Workflow Visualization
```mermaid
flowchart TD
    A[Start Command] --> B[Parse Arguments]
    B --> C{Special Case?}
    C -->|Shop contains 'language'| D[Require shopID]
    C -->|Normal shop| E[Prepare parameters]
    D --> E
    E --> F[Set type='inaktive']
    F --> G[Execute Deletion]
    G --> H[DeleteInaktiveService]
    H --> I[Cleanup Resources]
    I --> J[Return Success]
```

## Example Usage
```bash
# Delete all inactive products (default behavior)
bin/console sisi-Produkt-inaktive:delete

# Target normal sales channel
bin/console sisi-Produkt-inaktive:delete main_store

# Target language-specific shop (requires shopID)
bin/console sisi-Produkt-inaktive:delete language_shop 2fbb5fe2e29a4d70aa5854ce7ce3e20b

# Delete only English indexes
bin/console sisi-Produkt-inaktive:delete '' '' '' en-GB

# Keep last 5 indexes (delete older ones)
bin/console sisi-Produkt-inaktive:delete '' '' 5

# Full parameter example (language-specific shop with English language)
bin/console sisi-Produkt-inaktive:delete language_shop 2fbb5fe2e29a4d70aa5854ce7ce3e20b 3 en-GB
```

## Implementation Notes
1. **Service Integration**: 
   - Uses `DeleteInaktiveService::deleteIndex()` for core functionality
   - Leverages `TextService::stripOption()` for parameter sanitization

2. **Error Handling**: 
   - Logs errors via Monolog `Logger` service
   - Returns exit code 0 on success, non-zero on failure

3. **Performance Considerations**: 
   - Processes deletions in batches for large catalogs
   - Uses connection pooling for database efficiency

4. **Security**: 
   - Validates all input parameters
   - Implements proper access controls