# Sisi Produkt Stepindex Command

## Command Name
`sisi-Produkt-Stepindex:start`

## Purpose
Performs batched indexing of products into Elasticsearch to efficiently handle large catalogs while maintaining system stability.

## CLI Arguments and Options

### Arguments (Positional)
| Argument      | Required | Default | Description |
|---------------|----------|---------|-------------|
| `shop`        | Yes      | -       | Sales channel name (human-readable). If provided without `shopID`, the system will look up the corresponding ID. |
| `shopID`      | No       | -       | Sales channel ID (UUID). Use to bypass name resolution. If provided with `shop`, validates that the name matches the ID. |
| `limit`       | No       | 1000    | Number of products per batch |
| `main`        | No       | -       | Only index main products |
| `time`        | No       | -       | Days to consider for updates |
| `update`      | No       | -       | Update mode: "1" (created) or "2" (created/updated) |
| `language`    | No       | -       | Language code (e.g., "en-GB") - Specifies which language to index. Can be used with languageID. |
| `languageID`  | No       | -       | Language ID (UUID) - Directly specifies language by ID. Useful when code is unknown. Can be used with language. |
| `offset`      | No       | 0       | Starting offset for batch processing |


## Language Handling
The command supports multilingual indexing through two complementary arguments:

- `language`: 
  - Accepts language codes (e.g., "en-GB", "de-DE")
  - Used when you know the language code but not the ID
  - Example: `language:en-GB`

- `languageID`:
  - Accepts Shopware language UUIDs
  - Used when you know the language ID but not the code
  - Example: `languageID:2fbb5fe2e29a4d70aa5854ce7ce3e20b`

Both arguments can be used:
- Together for validation (ensuring ID matches code)
- Independently when only one identifier is known
- When both are omitted, uses the default language

## Sales Channel Identification
The command supports dual identification methods to balance convenience and performance:

- `shop` (Name):
  - Human-readable identifier (sales channel name)
  - Requires internal lookup to resolve to ID
  - Ideal for manual command execution

- `shopID` (UUID):
  - Direct database reference (sales channel ID)
  - Bypasses name resolution step
  - Preferred for automated/scripted use

When both parameters are provided:
- System validates that the provided name matches the provided ID
- Command fails with an error if a mismatch is detected

### Sales Channel Resolution Flow
```mermaid
flowchart LR
    A[Command Start] --> B{shop provided?}
    B -->|Yes| C[Lookup ID from name]
    B -->|No| D{shopID provided?}
    D -->|Yes| E[Use directly]
    D -->|No| F[Error: Missing shop identifier]
    C --> G{shopID also provided?}
    G -->|Yes| H[Validate match]
    G -->|No| I[Proceed with resolved ID]
    H -->|Match| I
    H -->|Mismatch| J[Fail with error]
```

## Workflow Visualization
```mermaid
flowchart TD
    A[Start Command] --> B[Parse Arguments]
    B --> C[Initialize Batch Indexing]
    C --> D{More Products?}
    D -- Yes --> E[Process Batch]
    E --> F[Index Products]
    F --> G[Update Progress]
    G --> D
    D -- No --> H[Index Categories?]
    H -- Yes --> I[Process Categories]
    H -- No --> J[Set Finish Flag]
    I --> J
    J --> K[Output Completion]
```

## Example Usage
```bash
# Full catalog index (using positional arguments)
bin/console sisi-Produkt-Stepindex:start your_shop_name

# Full catalog index (using named options)
bin/console sisi-Produkt-Stepindex:start shop:your_shop_name

# Update only products modified in last 7 days
bin/console sisi-Produkt-Stepindex:start shop:your_shop_name time:7 update:2

# Multilingual indexing with language ID
bin/console sisi-Produkt-Stepindex:start shop:your_shop_name languageID:2fbb5fe2e29a4d70aa5854ce7ce3e20b

# Name only (system resolves ID)
bin/console sisi-Produkt-Stepindex:start your_shop_name

# ID only (skip name resolution)
bin/console sisi-Produkt-Stepindex:start shopID:2fbb5fe2e29a4d70aa5854ce7ce3e20b

# Both (validation)
bin/console sisi-Produkt-Stepindex:start shop:your_shop_name shopID:2fbb5fe2e29a4d70aa5854ce7ce3e20b
```

## Notes
- Uses garbage collection (`gc_collect_cycles()`) between batches to manage memory
- Progress is tracked in database table `s_plugin_sisi_search_es_index`
- Category indexing runs only on first batch if configured in plugin settings
- Language settings affect both product data and category indexing