<?php

namespace Sisi\Search\Commands;

use Shopware\Core\Content\Product\AbstractPropertyGroupSorter;
use Shopware\Core\System\SalesChannel\Context\AbstractSalesChannelContextFactory;
use Sisi\Search\Service\SearchkeyService;
use Sisi\Search\Service\StartService;
use Sisi\Search\Service\TaskService;
use Sisi\Search\ServicesInterfaces\InterfaceSearchCategorieService;
use Symfony\Bridge\Monolog\Logger;
use Sisi\Search\ESindexing\ProduktDataIndexer;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Shopware\Core\Framework\Context;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Doctrine\DBAL\Connection;
use Shopware\Elasticsearch\Framework\ElasticsearchHelper;
use Shopware\Core\Checkout\Cart\Price\QuantityPriceCalculator;
use Sisi\Search\Service\TextService;
use Symfony\Component\Console\Attribute\AsCommand;

/**
 * Class ProductStepIndexerCommand
 * @package Sisi\Search\Commands
 *
 * @SuppressWarnings(PHPMD)
 */

#[AsCommand(name: 'sisi-Search-Index:start')]
class SisiSearchIndexCommand extends Command
{
    /**
     *
     * @var SystemConfigService
     */
    protected $config;

    protected static $defaultName = 'sisi-Search-Index:start';

    public function __construct(SystemConfigService $config)
    {
        parent::__construct();
        $this->config = $config;
    }

    protected function configure(): void
    {
        $this->addArgument('shop', InputArgument::OPTIONAL, 'Shop Channel');
        $this->addArgument('shopID', InputArgument::OPTIONAL, 'Shop Channel Id');
        $this->addArgument('limit', InputArgument::OPTIONAL, 'You can add the limit');
        $this->addArgument('main', InputArgument::OPTIONAL, 'Only add main Products in the Index');


        $this->addArgument(
            'time',
            InputArgument::OPTIONAL,
            'Enter the days which will be used for the update index process'
        );
        $this->addArgument(
            'update',
            InputArgument::OPTIONAL,
            'Update the index with update="1"'
        );

        $this->addArgument(
            'language',
            InputArgument::OPTIONAL,
            'This parameter is necessary when you want use not the default language'
        );
        $this->addArgument(
            'languageID',
            InputArgument::OPTIONAL,
            'This parameter is necessary when you want use not the default language and you know the language id'
        );

        $this->addArgument(
            'stop',
            InputArgument::OPTIONAL
        );


        $this->setDescription('Execute the index Memory optimized');
    }


    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Sisi Index Command indexer');
        $arguments = $input->getArguments();
        $texthaendler = new TextService();
        $parameter = $texthaendler->stripOption($arguments);
        $config = $this->config->get("SisiSearch.config");
        $extendCommand = "";
        $phpPad = "php ";
        $strUpdate = true;
        $strTime = true;
        if (!array_key_exists('limit', $arguments)) {
            $parameter['limit'] = 1000;
        }
        if (empty($parameter['limit'])) {
            $parameter['limit'] = 1000;
        }
        if (array_key_exists('update', $parameter)) {
            $extendCommand .= " update=" . $parameter['update'];
            $strUpdate = false;
        }
        if (array_key_exists('language', $parameter) && !array_key_exists('languageID', $parameter)) {
            $extendCommand .= ' language="' . $parameter['language'] . '"';
        }
        if (array_key_exists('languageID', $parameter)) {
            $extendCommand .= ' languageID="' . $parameter['languageID'] . '"';
        }
        if (array_key_exists('time', $parameter)) {
            $extendCommand .= ' time="' . $parameter['time'] . '"';
            $strTime = false;
        }
        $shop = $input->getArgument('shop');
        $shop = str_replace("shop=", "", $shop);
        $phpPad = $this->getPhpPfad($config);
        $maincommand = $phpPad . 'bin/console sisi-Produkt-Stepindex:start shop="' . $shop . '" limit=' . $parameter['limit'] . $extendCommand;
        $str = true;
        $index = 0;
        while ($str) {
            $extendCommand = "";
            if ($index > 0) {
                $extendCommand = " offset=" . $index;
                if ($strUpdate) {
                    $extendCommand .= " update=3";
                }
                if ($strTime) {
                    $extendCommand .= " time=1";
                }
            }
            $extendCommand .= " stop=" .  ($index + $parameter['limit']);
            $command = $maincommand . $extendCommand;
            echo $command . "\n";
            $output = shell_exec($command);
            var_dump($output);
            $pos = strpos($output, "Next 0");
            if ($pos !== false) {
                $str = false;
            }
            $pos = strpos($output, "The index process is finish");
            if ($pos === false) {
                $str = false;
            }
            $index = $index + $parameter['limit'];
        }
        return 0;
    }

    private function getPhpPfad(array $config): string
    {
        $phpPad = 'php ';
        if (array_key_exists('phpPad', $config)) {
            if (!empty($config['phpPad'])) {
                $phpPad = $config['phpPad'] . ' ';
            }
        }
        return $phpPad;
    }
}
