<?php

declare(strict_types=1);

namespace Sisi\Search\Api;

use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Plugin\Exception\DecorationPatternException;
use Shopware\Core\Framework\Routing\Annotation\Entity;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\DBAL\Connection;
use OpenApi\Annotations as OA;
use Shopware\Core\Checkout\Cart\Price\QuantityPriceCalculator;
use Shopware\Core\Content\Product\AbstractPropertyGroupSorter;
use Shopware\Core\Framework\Context;
use Shopware\Core\System\SalesChannel\Context\AbstractSalesChannelContextFactory;
use Shopware\Core\System\SalesChannel\Context\SalesChannelContextService;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Sisi\Search\ESIndexInterfaces\InterfaceCreateCriteria;
use Sisi\Search\ESIndexInterfaces\InterSearchAjaxService;
use Sisi\Search\ServicesInterfaces\InterfaceFrontendService;
use Sisi\Search\ServicesInterfaces\InterfaceQuerylogSearchService;
use Sisi\Search\ServicesInterfaces\InterfaceSearchCategorieService;
use Sisi\Search\ServicesInterfaces\InterfaceSisiProductPriceCalculator;
use Sisi\Search\Service\ContextService;
use Sisi\Search\Service\SearchEventService;
use Sisi\Search\Service\SearchService;
use Sisi\Search\Storefront\Page\SearchPageLoader;
use Symfony\Bridge\Monolog\Logger;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route(defaults={"_routeScope"={"store-api"}})
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class ApiRoute extends AbstractApiRoute
{
      /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    /**
     * @var SystemConfigService
     */
    private $systemConfigService;

    /**
     * @var Connection
     */
    private $connection;

    /**
     * @var searchService
     */
    protected $searchService;

    /**
     * @var InterfaceCreateCriteria
     */
    private $createCriteria;

    /**
     *
     * @var Logger
     */
    protected $loggingService;

    /**
     *
     * @var InterfaceFrontendService
     */
    private $frontendService;

    /**
     * @var SearchPageLoader
     */
    private $loader;

    /**
     * @var InterSearchAjaxService
     */
    private $searchajax;

    /**
     * @var InterfaceSearchCategorieService
     */
    protected $searchCategorieService;

    /**
     * @var QuantityPriceCalculator
     *
     */
    protected QuantityPriceCalculator $calculator;

    /**
     * @var AbstractPropertyGroupSorter
     */
    protected $propertyGroupSorter;

    /**
     * @var  InterfaceSisiProductPriceCalculator
     */
    protected $sisiProductPriceCalculator;

    /**
     *
     * @var  AbstractSalesChannelContextFactory
     */
    private $salesChannelContextFactory;

    /**
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     * @param SystemConfigService $systemConfigService
     * @param Connection $connection
     * @param ContainerInterface $container
     * @param InterfaceCreateCriteria $createCriteria
     * @param Logger $loggingService
     * @param InterfaceFrontendService $frontendService
     * @param SearchPageLoader $loader
     * @param EventDispatcherInterface $eventDispatcher
     * @param InterSearchAjaxService $searchajax
     * @param InterfaceSearchCategorieService $searchCategorieService
     * @param InterfaceQuerylogSearchService $querylogSearchService
     * @param InterfaceSisiProductPriceCalculator $sisiProductPriceCalculator
     * @param AbstractPropertyGroupSorter $propertyGroupSorter
     */

    public function __construct(
        SystemConfigService $systemConfigService,
        Connection $connection,
        ContainerInterface $container,
        InterfaceCreateCriteria $createCriteria,
        Logger $loggingService,
        InterfaceFrontendService $frontendService,
        SearchPageLoader $loader,
        EventDispatcherInterface $eventDispatcher,
        InterSearchAjaxService $searchajax,
        InterfaceSearchCategorieService $searchCategorieService,
        InterfaceQuerylogSearchService $querylogSearchService,
        InterfaceSisiProductPriceCalculator $sisiProductPriceCalculator,
        AbstractPropertyGroupSorter $propertyGroupSorter,
        AbstractSalesChannelContextFactory $salesChannelContextFactory
    ) {
        $this->systemConfigService = $systemConfigService;
        $this->connection = $connection;
        $this->container = $container;
        $this->loggingService = $loggingService;
        $this->frontendService = $frontendService;
        $this->searchCategorieService = $searchCategorieService;
        $this->searchService = new SearchService(
            $systemConfigService,
            $connection,
            $container,
            $loggingService,
            $searchCategorieService,
            $querylogSearchService
        );
        $this->createCriteria = $createCriteria;
        $this->loader = $loader;
        $this->eventDispatcher = $eventDispatcher;
        $this->searchajax = $searchajax;
        $this->sisiProductPriceCalculator = $sisiProductPriceCalculator;
        $this->propertyGroupSorter = $propertyGroupSorter;
        $this->salesChannelContextFactory = $salesChannelContextFactory;
    }


    public function getDecorated(): AbstractApiRoute
    {
        throw new DecorationPatternException(self::class);
    }

    /**
     * @Route("/store-api/sisisearch", name="store-api.sisisearch.search", methods={"GET"})
     */
    public function load(Request $request, SalesChannelContext $saleschannelContext): JsonResponse
    {
        $return = [];
        $strApi = false;
        $systemConfig = $this->systemConfigService->get("SisiSearch.config", $saleschannelContext->getSalesChannel()->getId());
        if (array_key_exists('storefrontapi', $systemConfig)) {
            if ($systemConfig['storefrontapi'] === '1') {
                $strApi = true;
            }
        }
        if ($strApi) {
            $page = $this->loader->loadSuggest($request, $saleschannelContext);
            $heandler = new SearchEventService($this->connection, $systemConfig, $this->container);
            $systemConfig['sisiProductPriceCalculator'] = $this->sisiProductPriceCalculator;
            $systemConfig['propertyGroupSorter'] = $this->propertyGroupSorter;
            $systemConfig['isApi'] = true;
            $return = $heandler->onSuggestSearch($page, $this->searchService, $this->frontendService, $saleschannelContext, $request, $systemConfig);
            if (array_key_exists('sisi_col_search', $return)) {
                unset($return['sisi_col_search']);
            }
        }
        return new JsonResponse($return);
    }
}
