<?php

declare(strict_types=1);

namespace Sisi\Search\Api;

use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Shopware\Core\Framework\Context;
use Symfony\Component\HttpFoundation\JsonResponse;

abstract class AbstractApiRoute
{
    abstract public function getDecorated(): AbstractApiRoute;

    abstract public function load(Request $request, SalesChannelContext $context): JsonResponse;
}
