<?php

namespace Sisi\Search\Service;

use Elasticsearch\Client;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class InsertService
 * @package Sisi\Search\Service
 * @SuppressWarnings(PHPMD)
 */
class Recommender
{
    public function addConfigForNoTags(array $config): array
    {
        return $config;
    }
    public function setFragmentSize(array $config, array $params): array
    {
        $fragmentsize = 5;

        if (array_key_exists('fragmentsizerecommender', $config)) {
            $fragmentsize = (int) $config['fragmentsizerecommender'];
        }

        if (array_key_exists('querysizerecommender', $config)) {
             $params['size'] = $config['querysizerecommender'];
        }

        $params['body']['highlight']['fragment_size'] = $fragmentsize;
        return $params;
    }

    public function mergeRecommnderQuery($fieldsconfig, $match, $search, $terms): array
    {
        $fields = [];
        $helpService = new SearchHelpService();
        $queryheandler = new QueryService();
        $index = 0;
        foreach ($fieldsconfig as $row) {
            $name = $helpService->setField($row);
            $isRecommdationField = $row->getOnlymain();
            if ($isRecommdationField === 'recommender') {
                $queryheandler->mergeFields(
                    $index,
                    $fields,
                    $match,
                    $search,
                    $row,
                    $name,
                    $terms
                );
            }
        }
        return $fields;
    }

    public function searchRecommender($frontendService, client $client, array $params, SalesChannelContext $saleschannelContext, ContainerInterface $container): array
    {
        $hits = [];
        $results = $frontendService->search($client, $params, $saleschannelContext, $container);
        foreach ($results['hits']['hits'] as &$result) {
            if (array_key_exists("highlight", $result)) {
                foreach ($result["highlight"] as $item) {
                    foreach ($item as $itemValue) {
                        if (!in_array($itemValue, $hits)) {
                            $hits[] = $itemValue;
                        }
                    }
                }
            }
        }
        return $hits;
    }
}
