# API Definition Generation

This directory contains the necessary components and schema files for generating the OpenAPI specifications for the StoreAPI and the AdminAPI.

## Overview

The core logic is built around `ApiDefinitionGeneratorInterface`. Generators implement this interface to produce an OpenAPI specification for a specific API format. The generation process typically combines two sources:

1.  **Auto-generated schemas:** based on the `EntityDefinition`s registered in the system.
2.  **Manual schema files:** static `.json` files that define or override paths, components, and parameters.

---

## StoreAPI Generation

The OpenAPI specification for the StoreAPI is generated by the `Shopware\Core\Framework\Api\ApiDefinition\Generator\StoreApiGenerator`. This generator builds the final schema by merging information from the next sources:

1.  **Entity Definitions:** it inspects all `EntityDefinition`s that are available for the StoreAPI (`SalesChannelDefinitionInterface`) to automatically generate base schemas for entities.
2.  **Static Schema Files:** it recursively loads all `.json` files from the `src/Core/Framework/Api/ApiDefinition/Generator/Schema/StoreApi/` directory. These files are used to define API paths, reusable components, and custom extensions.

### Using `x-parameter-group` for Reusable Parameters

> [!WARNING]  
> This functionality was added to decrease duplication for criteria related parameters, is experimental and may be removed any time. Please refrain from relying on.

The OpenAPI 3.1 standard does not natively support reusable parameter groups across different endpoints. As a lot of StoreAPI endpoints share common query parameters sets (Criteria, ProductListingCriteria), we introduce a custom `x-parameter-group` extension to allow reuse of these parameters without a need to duplicate them across multiple endpoint definitions.

The `StoreApiGenerator` recognizes the `x-parameter-group` key and replaces it with a predefined list of parameters.

**Usage example:**

A parameter group is defined in a file within `src/Core/Framework/Api/ApiDefinition/Generator/Schema/StoreApi/components/parameters/`. For instance, to define a reusable `pagination` group:

**`.../parameters/pagination.json`**
```json
{
    "components": {
        "x-parameter-groups": {
            "pagination": [
                {
                    "name": "page",
                    "in": "query",
                    "schema": { "type": "integer", "default": 1 }
                },
                {
                    "name": "limit",
                    "in": "query",
                    "schema": { "type": "integer", "default": 25 }
                }
            ]
        }
    }
}
```

You can then use this group in any endpoint definition:

**`.../paths/my-endpoint.json`**
```json
{
    "paths": {
        "/my-endpoint": {
            "get": {
                "summary": "Get a paginated list of items.",
                "parameters": [
                    {
                        "x-parameter-group": "pagination"
                    }
                ],
                "responses": {
                    "200": { "$ref": "#/components/responses/my_item_list" }
                }
            }
        }
    }
}
```

Currently, the next parameters groups are defined:
 - `criteria`
 - `noneFieldsCriteria`
 - `productListingCriteria`
