const s=`{% block sw_import_export_importer %} <div class="sw-import-export-importer"> {% block sw_import_export_importer_upload_csv_label %} <span class="sw-import-export-importer__title"> {{ $tc('sw-import-export.importer.uploadCsvLabel') }} </span> {% endblock %} {% block sw_import_export_importer_warning_block %} <p class="sw-import-export-importer__text"> <span v-html="$tc('sw-import-export.importer.warningBlock')"></span> </p> {% endblock %} {% block sw_import_export_importer_file_input %} <sw-file-input :key="isLoading" v-model:value="importFile" > <template #caption-label> {{ $tc('sw-import-export.importer.labelUploadCaption') }} </template> </sw-file-input> {% endblock %} {% block sw_import_export_importer_select_profile_label %}{% endblock %} {% block sw_import_export_importer_profile_select %} <sw-entity-single-select class="sw-import-export-importer__profile-select" :disabled="isLoading" :label="$tc('sw-import-export.importer.profileLabel')" entity="import_export_profile" label-property="technicalName" :criteria="profileCriteria" :value="selectedProfileId" required @update:value="onProfileSelect" /> {% endblock %} <template v-if="selectedProfile && selectedProfile.sourceEntity === 'product'"> {% block sw_import_export_importer_profile_select_product_variants_switch %} <mt-switch v-model="config.includeVariants" class="sw-import-export-importer__variants-switch-field" :label="$tc('sw-import-export.importer.importVariants')" /> {% endblock %} </template> <template v-if="showProductVariantsInfo"> {% block sw_import_export_importer_product_variants_warning %} <mt-banner variant="attention" class="sw-import-export-importer__variants-warning" > {% block sw_import_export_importer_product_variants_warning_text %} <p> <span v-html="$tc('sw-import-export.importer.variantsWarning')"></span> </p> <p> <a href="#" class="sw-import-export-importer__link" @click.prevent="setImportModalProfile('product_configurator_setting')" > {{ $tc('sw-import-export.importer.directImportVariantsLabel') }} </a> <br> <a href="#" class="sw-import-export-importer__link" @click.prevent="setImportModalProfile('property_group_option')" > {{ $tc('sw-import-export.importer.directImportPropertiesLabel') }} </a> </p> {% endblock %} </mt-banner> {% endblock %} </template> {% block sw_import_export_importer_modal %} <sw-modal v-if="importModalProfile" :title="$tc('sw-import-export.importer.importLabel')" @modal-close="setImportModalProfile(null)" > {% block sw_import_export_importer_modal_exporter %} <sw-import-export-importer :source-entity="importModalProfile" @import-started="$emit('import-started', $event)" /> {% endblock %} <template #modal-footer> {% block sw_import_export_importer_modal_footer %} <mt-button size="small" variant="secondary" @click="setImportModalProfile(null)" > {{ $tc('sw-import-export.importer.close') }} </mt-button> {% endblock %} </template> </sw-modal> {% endblock %} {% block sw_import_export_importer_progress %} <sw-import-export-progress activity-type="import" :disable-button="disableImporting" @process-start="onStartProcess" @process-start-dryrun="onStartDryRunProcess" /> {% endblock %} </div> {% endblock %}`,{Mixin:p}=Shopware,{Criteria:e}=Shopware.Data,l={template:s,inject:["importExport","repositoryFactory","feature"],emits:["import-started"],mixins:[p.getByName("notification")],props:{sourceEntity:{type:String,required:!1,default:""}},data(){return{selectedProfileId:null,selectedProfile:null,config:{},isLoading:!1,importFile:null,importModalProfile:null}},computed:{profileCriteria(){const t=new e(1,25);return t.addSorting(e.sort("label")),this.sourceEntity.length>0&&t.addFilter(e.equals("sourceEntity",this.sourceEntity)),t.addFilter(e.not("AND",[e.equals("type","export")])),t},logRepository(){return this.repositoryFactory.create("import_export_log")},disableImporting(){return this.isLoading||this.selectedProfileId===null||this.importFile===null},showProductVariantsInfo(){return this.selectedProfile&&this.selectedProfile.sourceEntity==="product"&&this.config&&this.config.includeVariants},logCriteria(){const t=new e(1,25);return t.addAssociation("invalidRecordsLog"),t.addAssociation("file"),t}},methods:{onProfileSelect(t,o){this.selectedProfileId=t,this.selectedProfile=o},onStartProcess(t=!1){this.isLoading=!0;const o=this.selectedProfileId;this.importExport.import(o,this.importFile,this.handleProgress,this.config,t).then(()=>{this.importFile=null}).catch(r=>{!r.response||!r.response.data||!r.response.data.errors?this.createNotificationError({message:r.message}):r.response.data.errors.forEach(i=>{this.createNotificationError({message:`${i.code}: ${i.detail}`})}),this.isLoading=!1})},onStartDryRunProcess(){this.onStartProcess(!0)},handleProgress(t){this.createNotificationInfo({message:this.$tc("sw-import-export.importer.messageImportStarted")}),this.isLoading=!1,this.$emit("import-started",t)},setImportModalProfile(t){this.importModalProfile=t}}};export{l as default};
