<?php

namespace Symfony\Config\Shopware;

use Symfony\Component\Config\Loader\ParamConfigurator;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;

/**
 * This class is automatically generated to help in creating a config.
 */
class AdminLoginConfig 
{
    private $useDefault;
    private $clientId;
    private $clientSecret;
    private $redirectUri;
    private $baseUrl;
    private $authorizePath;
    private $tokenPath;
    private $jwksPath;
    private $scope;
    private $registerUrl;
    private $_usedProperties = [];

    /**
     * @default null
     * @param ParamConfigurator|bool $value
     * @return $this
     */
    public function useDefault($value): static
    {
        $this->_usedProperties['useDefault'] = true;
        $this->useDefault = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function clientId($value): static
    {
        $this->_usedProperties['clientId'] = true;
        $this->clientId = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function clientSecret($value): static
    {
        $this->_usedProperties['clientSecret'] = true;
        $this->clientSecret = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function redirectUri($value): static
    {
        $this->_usedProperties['redirectUri'] = true;
        $this->redirectUri = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function baseUrl($value): static
    {
        $this->_usedProperties['baseUrl'] = true;
        $this->baseUrl = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function authorizePath($value): static
    {
        $this->_usedProperties['authorizePath'] = true;
        $this->authorizePath = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function tokenPath($value): static
    {
        $this->_usedProperties['tokenPath'] = true;
        $this->tokenPath = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function jwksPath($value): static
    {
        $this->_usedProperties['jwksPath'] = true;
        $this->jwksPath = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function scope($value): static
    {
        $this->_usedProperties['scope'] = true;
        $this->scope = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function registerUrl($value): static
    {
        $this->_usedProperties['registerUrl'] = true;
        $this->registerUrl = $value;

        return $this;
    }

    public function __construct(array $value = [])
    {
        if (array_key_exists('use_default', $value)) {
            $this->_usedProperties['useDefault'] = true;
            $this->useDefault = $value['use_default'];
            unset($value['use_default']);
        }

        if (array_key_exists('client_id', $value)) {
            $this->_usedProperties['clientId'] = true;
            $this->clientId = $value['client_id'];
            unset($value['client_id']);
        }

        if (array_key_exists('client_secret', $value)) {
            $this->_usedProperties['clientSecret'] = true;
            $this->clientSecret = $value['client_secret'];
            unset($value['client_secret']);
        }

        if (array_key_exists('redirect_uri', $value)) {
            $this->_usedProperties['redirectUri'] = true;
            $this->redirectUri = $value['redirect_uri'];
            unset($value['redirect_uri']);
        }

        if (array_key_exists('base_url', $value)) {
            $this->_usedProperties['baseUrl'] = true;
            $this->baseUrl = $value['base_url'];
            unset($value['base_url']);
        }

        if (array_key_exists('authorize_path', $value)) {
            $this->_usedProperties['authorizePath'] = true;
            $this->authorizePath = $value['authorize_path'];
            unset($value['authorize_path']);
        }

        if (array_key_exists('token_path', $value)) {
            $this->_usedProperties['tokenPath'] = true;
            $this->tokenPath = $value['token_path'];
            unset($value['token_path']);
        }

        if (array_key_exists('jwks_path', $value)) {
            $this->_usedProperties['jwksPath'] = true;
            $this->jwksPath = $value['jwks_path'];
            unset($value['jwks_path']);
        }

        if (array_key_exists('scope', $value)) {
            $this->_usedProperties['scope'] = true;
            $this->scope = $value['scope'];
            unset($value['scope']);
        }

        if (array_key_exists('register_url', $value)) {
            $this->_usedProperties['registerUrl'] = true;
            $this->registerUrl = $value['register_url'];
            unset($value['register_url']);
        }

        if ([] !== $value) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($value)));
        }
    }

    public function toArray(): array
    {
        $output = [];
        if (isset($this->_usedProperties['useDefault'])) {
            $output['use_default'] = $this->useDefault;
        }
        if (isset($this->_usedProperties['clientId'])) {
            $output['client_id'] = $this->clientId;
        }
        if (isset($this->_usedProperties['clientSecret'])) {
            $output['client_secret'] = $this->clientSecret;
        }
        if (isset($this->_usedProperties['redirectUri'])) {
            $output['redirect_uri'] = $this->redirectUri;
        }
        if (isset($this->_usedProperties['baseUrl'])) {
            $output['base_url'] = $this->baseUrl;
        }
        if (isset($this->_usedProperties['authorizePath'])) {
            $output['authorize_path'] = $this->authorizePath;
        }
        if (isset($this->_usedProperties['tokenPath'])) {
            $output['token_path'] = $this->tokenPath;
        }
        if (isset($this->_usedProperties['jwksPath'])) {
            $output['jwks_path'] = $this->jwksPath;
        }
        if (isset($this->_usedProperties['scope'])) {
            $output['scope'] = $this->scope;
        }
        if (isset($this->_usedProperties['registerUrl'])) {
            $output['register_url'] = $this->registerUrl;
        }

        return $output;
    }

}
